/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.batch.bootstrapper.LogCallbackAppender;
import org.sonar.batch.bootstrapper.LogOutput;
import org.sonar.batch.bootstrapper.LoggingConfiguration;
import org.sonar.core.config.Logback;

public class LoggingConfigurator {
    private static final String CUSTOM_APPENDER_NAME = "custom_stream";

    private LoggingConfigurator() {
    }

    public static void apply(LoggingConfiguration conf, File logbackFile) {
        Logback.configure((File)logbackFile, conf.getSubstitutionVariables());
        if (conf.getLogOutput() != null) {
            LoggingConfigurator.setCustomRootAppender(conf);
        }
    }

    public static void apply(LoggingConfiguration conf) {
        LoggingConfigurator.apply(conf, "/org/sonar/batch/bootstrapper/logback.xml");
    }

    public static void apply(LoggingConfiguration conf, String classloaderPath) {
        Logback.configure((String)classloaderPath, conf.getSubstitutionVariables());
        if (conf.getLogOutput() != null) {
            LoggingConfigurator.setCustomRootAppender(conf);
        }
    }

    private static void setCustomRootAppender(LoggingConfiguration conf) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        String level = StringUtils.defaultIfBlank((String)conf.getSubstitutionVariables().get("ROOT_LOGGER_LEVEL"), (String)"INFO");
        if (logger.getAppender(CUSTOM_APPENDER_NAME) == null) {
            logger.detachAndStopAllAppenders();
            logger.addAppender(LoggingConfigurator.createAppender(conf.getLogOutput()));
        }
        logger.setLevel(Level.toLevel((String)level));
    }

    private static Appender<ILoggingEvent> createAppender(LogOutput target) {
        LogCallbackAppender appender = new LogCallbackAppender(target);
        appender.setName(CUSTOM_APPENDER_NAME);
        appender.start();
        return appender;
    }
}

