/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.strategy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.scm.git.strategy.BlameStrategy;

public class DefaultBlameStrategy
implements BlameStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBlameStrategy.class);
    private static final int FILES_GIT_BLAME_TRIGGER = 10;
    public static final String PROP_SONAR_SCM_USE_BLAME_ALGORITHM = "sonar.scm.use.blame.algorithm";
    private final Configuration configuration;

    public DefaultBlameStrategy(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public BlameAlgorithmEnum getBlameAlgorithm(int availableProcessors, int numberOfFiles) {
        BlameAlgorithmEnum forcedStrategy = this.configuration.get(PROP_SONAR_SCM_USE_BLAME_ALGORITHM).map(BlameAlgorithmEnum::valueOf).orElse(null);
        if (forcedStrategy != null) {
            return forcedStrategy;
        }
        if (availableProcessors == 0) {
            LOG.warn("Available processors are 0. Falling back to native git blame");
            return BlameAlgorithmEnum.GIT_NATIVE_BLAME;
        }
        if (numberOfFiles / availableProcessors > 10) {
            return BlameAlgorithmEnum.GIT_FILES_BLAME;
        }
        return BlameAlgorithmEnum.GIT_NATIVE_BLAME;
    }

    public static enum BlameAlgorithmEnum {
        GIT_NATIVE_BLAME,
        GIT_FILES_BLAME;

    }
}

