/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWrapperFactory.class);

    public ProcessWrapper create(@Nullable Path baseDir, Consumer<String> stdOutLineConsumer, String ... command) {
        return new ProcessWrapper(baseDir, stdOutLineConsumer, command);
    }

    static class ProcessWrapper {
        private final Path baseDir;
        private final Consumer<String> stdOutLineConsumer;
        private final String[] command;

        ProcessWrapper(@Nullable Path baseDir, Consumer<String> stdOutLineConsumer, String ... command) {
            this.baseDir = baseDir;
            this.stdOutLineConsumer = stdOutLineConsumer;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws IOException {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(this.command).directory(this.baseDir != null ? this.baseDir.toFile() : null);
            Process p = pb.start();
            try {
                ProcessWrapper.processInputStream(p.getInputStream(), this.stdOutLineConsumer);
                ProcessWrapper.processInputStream(p.getErrorStream(), line -> {
                    if (!line.isBlank()) {
                        LOG.debug(line);
                    }
                });
                int exit = p.waitFor();
                if (exit != 0) {
                    throw new IllegalStateException(String.format("Command execution exited with code: %d", exit));
                }
            }
            catch (InterruptedException e) {
                LOG.warn(String.format("Command [%s] interrupted", String.join((CharSequence)" ", this.command)), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                p.destroy();
            }
        }

        private static void processInputStream(InputStream inputStream, Consumer<String> stringConsumer) {
            try (Scanner scanner = new Scanner(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                scanner.useDelimiter("\n");
                while (scanner.hasNext()) {
                    stringConsumer.accept(scanner.next());
                }
            }
        }
    }
}

