/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scm.git.JGitUtils;

public class IncludedFilesRepository {
    private static final Logger LOG = LoggerFactory.getLogger(IncludedFilesRepository.class);
    private final Set<Path> includedFiles = new HashSet<Path>();

    public IncludedFilesRepository(Path baseDir) throws IOException {
        this.indexFiles(baseDir);
        LOG.debug("{} non excluded files in this Git repository", (Object)this.includedFiles.size());
    }

    public boolean contains(Path absolutePath) {
        return this.includedFiles.contains(absolutePath);
    }

    private void indexFiles(Path baseDir) throws IOException {
        try (Repository repo = JGitUtils.buildRepository(baseDir);){
            this.collectFilesIterative(repo, baseDir);
        }
    }

    private void collectFiles(Repository repo, Path baseDir) throws IOException {
        Path workTreeRoot = repo.getWorkTree().toPath();
        FileTreeIterator workingTreeIt = new FileTreeIterator(repo);
        try (TreeWalk treeWalk = new TreeWalk(repo);){
            treeWalk.setRecursive(true);
            if (!workTreeRoot.equals(baseDir) && baseDir.startsWith(workTreeRoot)) {
                Path relativeBaseDir = workTreeRoot.relativize(baseDir);
                treeWalk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{relativeBaseDir.toString().replace('\\', '/')}));
            }
            treeWalk.addTree((AbstractTreeIterator)workingTreeIt);
            while (treeWalk.next()) {
                WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)treeWalk.getTree(0, WorkingTreeIterator.class);
                if (workingTreeIterator.isEntryIgnored()) continue;
                this.includedFiles.add(workTreeRoot.resolve(treeWalk.getPathString()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectFilesIterative(Repository repo, Path baseDir) throws IOException {
        this.collectFiles(repo, baseDir);
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex((Repository)repo);){
            while (submoduleWalk.next()) {
                Repository submoduleRepo = submoduleWalk.getRepository();
                try {
                    if (submoduleRepo == null) {
                        LOG.debug("Git submodule [{}] found, but has not been cloned, skipping.", (Object)submoduleWalk.getPath());
                        continue;
                    }
                    this.collectFilesIterative(submoduleRepo, baseDir);
                }
                finally {
                    if (submoduleRepo == null) continue;
                    submoduleRepo.close();
                }
            }
            return;
        }
    }
}

