/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ChangedLinesComputer {
    private final Tracker tracker = new Tracker();
    private final OutputStream receiver = new OutputStream(){
        StringBuilder sb = new StringBuilder();

        @Override
        public void write(int b) {
            this.sb.append((char)b);
            if (b == 10) {
                ChangedLinesComputer.this.tracker.parseLine(this.sb.toString());
                this.sb.setLength(0);
            }
        }
    };

    ChangedLinesComputer() {
    }

    OutputStream receiver() {
        return this.receiver;
    }

    Set<Integer> changedLines() {
        return this.tracker.changedLines();
    }

    private static class Tracker {
        private static final Pattern START_LINE_IN_TARGET = Pattern.compile(" \\+(\\d+)");
        private final Set<Integer> changedLines = new HashSet<Integer>();
        private boolean foundStart = false;
        private int lineNumInTarget;

        private Tracker() {
        }

        private void parseLine(String line) {
            if (line.startsWith("@@ ")) {
                Matcher matcher = START_LINE_IN_TARGET.matcher(line);
                if (!matcher.find()) {
                    throw new IllegalStateException("Invalid block header on line " + line);
                }
                this.foundStart = true;
                this.lineNumInTarget = Integer.parseInt(matcher.group(1));
            } else if (this.foundStart) {
                char firstChar = line.charAt(0);
                if (firstChar == ' ') {
                    ++this.lineNumInTarget;
                } else if (firstChar == '+') {
                    this.changedLines.add(this.lineNumInTarget);
                    ++this.lineNumInTarget;
                }
            }
        }

        Set<Integer> changedLines() {
            return this.changedLines;
        }
    }
}

