/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.io.Serializable;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.batch.sensor.code.NewSignificantCode;
import org.sonar.api.batch.sensor.code.internal.DefaultSignificantCode;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.batch.sensor.rule.internal.DefaultAdHocRule;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.scanner.fs.InputProject;
import org.sonar.api.utils.Version;
import org.sonar.scanner.cache.AnalysisCacheEnabled;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.sensor.DefaultSensorStorage;
import org.sonar.scanner.sensor.UnchangedFilesHandler;
import org.sonar.scanner.sensor.noop.NoOpNewAnalysisError;

@ThreadSafe
public class ProjectSensorContext
implements SensorContext {
    static final NoOpNewAnalysisError NO_OP_NEW_ANALYSIS_ERROR = new NoOpNewAnalysisError();
    private final Settings mutableSettings;
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final DefaultSensorStorage sensorStorage;
    private final DefaultInputProject project;
    private final SonarRuntime sonarRuntime;
    private final Configuration config;
    private final boolean skipUnchangedFiles;
    private final UnchangedFilesHandler unchangedFilesHandler;
    private final WriteCache writeCache;
    private final ReadCache readCache;
    private final AnalysisCacheEnabled analysisCacheEnabled;

    public ProjectSensorContext(DefaultInputProject project, Configuration config, Settings mutableSettings, FileSystem fs, ActiveRules activeRules, DefaultSensorStorage sensorStorage, SonarRuntime sonarRuntime, BranchConfiguration branchConfiguration, WriteCache writeCache, ReadCache readCache, AnalysisCacheEnabled analysisCacheEnabled, UnchangedFilesHandler unchangedFilesHandler) {
        this.project = project;
        this.config = config;
        this.mutableSettings = mutableSettings;
        this.fs = fs;
        this.activeRules = activeRules;
        this.sensorStorage = sensorStorage;
        this.sonarRuntime = sonarRuntime;
        this.writeCache = writeCache;
        this.readCache = readCache;
        this.analysisCacheEnabled = analysisCacheEnabled;
        this.skipUnchangedFiles = branchConfiguration.isPullRequest();
        this.unchangedFilesHandler = unchangedFilesHandler;
    }

    public Settings settings() {
        return this.mutableSettings;
    }

    public Configuration config() {
        return this.config;
    }

    public FileSystem fileSystem() {
        return this.fs;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public InputModule module() {
        throw new UnsupportedOperationException("No modules for global Sensors");
    }

    public InputProject project() {
        return this.project;
    }

    public Version getSonarQubeVersion() {
        return this.sonarRuntime.getApiVersion();
    }

    public SonarRuntime runtime() {
        return this.sonarRuntime;
    }

    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure((SensorStorage)this.sensorStorage);
    }

    public NewIssue newIssue() {
        return new DefaultIssue(this.project, (SensorStorage)this.sensorStorage);
    }

    public NewExternalIssue newExternalIssue() {
        return new DefaultExternalIssue(this.project, (SensorStorage)this.sensorStorage);
    }

    public NewAdHocRule newAdHocRule() {
        return new DefaultAdHocRule((SensorStorage)this.sensorStorage);
    }

    public NewHighlighting newHighlighting() {
        return new DefaultHighlighting((SensorStorage)this.sensorStorage);
    }

    public NewSymbolTable newSymbolTable() {
        return new DefaultSymbolTable((SensorStorage)this.sensorStorage);
    }

    public NewCoverage newCoverage() {
        return new DefaultCoverage((SensorStorage)this.sensorStorage);
    }

    public NewCpdTokens newCpdTokens() {
        return new DefaultCpdTokens((SensorStorage)this.sensorStorage);
    }

    public NewAnalysisError newAnalysisError() {
        return NO_OP_NEW_ANALYSIS_ERROR;
    }

    public boolean isCancelled() {
        return false;
    }

    public void addContextProperty(String key, String value) {
        this.sensorStorage.storeProperty(key, value);
    }

    public void markForPublishing(InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        file.setPublished(true);
    }

    public void markAsUnchanged(InputFile inputFile) {
        this.unchangedFilesHandler.markAsUnchanged((DefaultInputFile)inputFile);
    }

    public WriteCache nextCache() {
        return this.writeCache;
    }

    public ReadCache previousCache() {
        return this.readCache;
    }

    public boolean isCacheEnabled() {
        return this.analysisCacheEnabled.isEnabled();
    }

    public NewSignificantCode newSignificantCode() {
        return new DefaultSignificantCode((SensorStorage)this.sensorStorage);
    }

    public boolean canSkipUnchangedFiles() {
        return this.skipUnchangedFiles;
    }
}

