/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.core.util.logs.Profiler;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.sensor.ExecutingSensorContext;
import org.sonar.scanner.sensor.ModuleSensorExtensionDictionary;
import org.sonar.scanner.sensor.ModuleSensorWrapper;
import org.sonar.scanner.sensor.SensorId;

public class ModuleSensorsExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleSensorsExecutor.class);
    private static final Profiler profiler = Profiler.create((Logger)LOG);
    private final ModuleSensorExtensionDictionary selector;
    private final SensorStrategy strategy;
    private final ScannerPluginRepository pluginRepo;
    private final ExecutingSensorContext executingSensorCtx;
    private final boolean isRoot;

    public ModuleSensorsExecutor(ModuleSensorExtensionDictionary selector, DefaultInputModule module, InputModuleHierarchy hierarchy, SensorStrategy strategy, ScannerPluginRepository pluginRepo, ExecutingSensorContext executingSensorCtx) {
        this.selector = selector;
        this.strategy = strategy;
        this.pluginRepo = pluginRepo;
        this.executingSensorCtx = executingSensorCtx;
        this.isRoot = hierarchy.isRoot(module);
    }

    public void execute() {
        ArrayList<ModuleSensorWrapper> moduleSensors = new ArrayList<ModuleSensorWrapper>();
        this.withModuleStrategy(() -> moduleSensors.addAll(this.selector.selectSensors(false)));
        ArrayList<ModuleSensorWrapper> deprecatedGlobalSensors = new ArrayList<ModuleSensorWrapper>();
        if (this.isRoot) {
            deprecatedGlobalSensors.addAll(this.selector.selectSensors(true));
        }
        this.printSensors(moduleSensors, deprecatedGlobalSensors);
        this.withModuleStrategy(() -> this.execute(moduleSensors));
        if (this.isRoot) {
            this.execute(deprecatedGlobalSensors);
        }
    }

    private void printSensors(Collection<ModuleSensorWrapper> moduleSensors, Collection<ModuleSensorWrapper> globalSensors) {
        String sensors = Stream.concat(moduleSensors.stream(), globalSensors.stream()).map(Object::toString).collect(Collectors.joining(" -> "));
        LOG.debug("Sensors : {}", (Object)sensors);
    }

    private void withModuleStrategy(Runnable r) {
        boolean orig = this.strategy.isGlobal();
        this.strategy.setGlobal(false);
        r.run();
        this.strategy.setGlobal(orig);
    }

    private void execute(Collection<ModuleSensorWrapper> sensors) {
        for (ModuleSensorWrapper sensor : sensors) {
            SensorId sensorId = this.getSensorId(sensor);
            profiler.startInfo("Sensor " + sensorId);
            this.executingSensorCtx.setSensorExecuting(sensorId);
            sensor.analyse();
            this.executingSensorCtx.clearExecutingSensor();
            profiler.stopInfo();
        }
    }

    private SensorId getSensorId(ModuleSensorWrapper sensor) {
        ClassLoader cl = ModuleSensorsExecutor.getSensorClassLoader(sensor);
        String pluginKey = this.pluginRepo.getPluginKey(cl);
        return new SensorId(pluginKey, sensor.toString());
    }

    private static ClassLoader getSensorClassLoader(ModuleSensorWrapper sensor) {
        return ((Sensor)sensor.wrappedSensor()).getClass().getClassLoader();
    }
}

