/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.config.Configuration;

public abstract class AbstractSensorOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSensorOptimizer.class);
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final Configuration config;

    public AbstractSensorOptimizer(FileSystem fs, ActiveRules activeRules, Configuration config) {
        this.fs = fs;
        this.activeRules = activeRules;
        this.config = config;
    }

    public boolean shouldExecute(DefaultSensorDescriptor descriptor) {
        if (!this.fsCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related file in current project", (Object)descriptor.name());
            return false;
        }
        if (!this.activeRulesCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related rule activated in the quality profile", (Object)descriptor.name());
            return false;
        }
        if (!this.settingsCondition(descriptor)) {
            LOG.debug("'{}' skipped because one of the required properties is missing", (Object)descriptor.name());
            return false;
        }
        return true;
    }

    private boolean settingsCondition(DefaultSensorDescriptor descriptor) {
        if (descriptor.configurationPredicate() != null) {
            return descriptor.configurationPredicate().test(this.config);
        }
        return true;
    }

    private boolean activeRulesCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.ruleRepositories().isEmpty()) {
            for (String repoKey : descriptor.ruleRepositories()) {
                if (this.activeRules.findByRepository(repoKey).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean fsCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.languages().isEmpty() || descriptor.type() != null) {
            FilePredicate langPredicate = descriptor.languages().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().hasLanguages(descriptor.languages());
            FilePredicate typePredicate = descriptor.type() == null ? this.fs.predicates().all() : this.fs.predicates().hasType(descriptor.type());
            return this.fs.hasFiles(this.fs.predicates().and(langPredicate, typePredicate));
        }
        return true;
    }
}

