/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.predicates.FileExtensionPredicate;
import org.sonar.api.utils.Preconditions;
import org.sonar.core.language.UnanalyzedLanguages;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class InputComponentStore
extends DefaultFileSystem.Cache {
    private static final Map<UnanalyzedLanguages, Pattern> FILE_PATTERN_BY_LANGUAGE = ImmutableMap.of((Object)UnanalyzedLanguages.C, (Object)Pattern.compile(".*\\.c", 2), (Object)UnanalyzedLanguages.CPP, (Object)Pattern.compile(".*\\.cpp|.*\\.cc|.*\\.cxx|.*\\.c\\+\\+", 2));
    private final SortedSet<String> globalLanguagesCache = new TreeSet<String>();
    private final Map<String, SortedSet<String>> languagesCache = new HashMap<String, SortedSet<String>>();
    private final Map<String, InputFile> globalInputFileCache = new HashMap<String, InputFile>();
    private final Map<String, Map<String, InputFile>> inputFileByModuleCache = new LinkedHashMap<String, Map<String, InputFile>>();
    private final Map<InputFile, String> inputModuleKeyByFileCache = new HashMap<InputFile, String>();
    private final Map<String, DefaultInputModule> inputModuleCache = new HashMap<String, DefaultInputModule>();
    private final Map<String, InputComponent> inputComponents = new HashMap<String, InputComponent>();
    private final Map<String, Set<InputFile>> filesByNameCache = new HashMap<String, Set<InputFile>>();
    private final Map<String, Set<InputFile>> filesByExtensionCache = new HashMap<String, Set<InputFile>>();
    private final BranchConfiguration branchConfiguration;
    private final SonarRuntime sonarRuntime;
    private final Map<String, Integer> notAnalysedFilesByLanguage = new HashMap<String, Integer>();

    public InputComponentStore(BranchConfiguration branchConfiguration, SonarRuntime sonarRuntime) {
        this.branchConfiguration = branchConfiguration;
        this.sonarRuntime = sonarRuntime;
    }

    public Collection<InputComponent> all() {
        return this.inputComponents.values();
    }

    private Stream<DefaultInputFile> allFilesToPublishStream() {
        return this.globalInputFileCache.values().stream().map(f -> (DefaultInputFile)f).filter(DefaultInputFile::isPublished);
    }

    public Iterable<DefaultInputFile> allFilesToPublish() {
        return this.allFilesToPublishStream()::iterator;
    }

    public Iterable<DefaultInputFile> allChangedFilesToPublish() {
        return this.allFilesToPublishStream().filter(f -> !this.branchConfiguration.isPullRequest() || f.status() != InputFile.Status.SAME)::iterator;
    }

    public Collection<InputFile> inputFiles() {
        return this.globalInputFileCache.values();
    }

    public InputComponent getByKey(String key) {
        return this.inputComponents.get(key);
    }

    public Iterable<InputFile> filesByModule(String moduleKey) {
        return this.inputFileByModuleCache.getOrDefault(moduleKey, Collections.emptyMap()).values();
    }

    public InputComponentStore put(String moduleKey, InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        this.updateNotAnalysedCAndCppFileCount(file);
        this.addToLanguageCache(moduleKey, file);
        this.inputFileByModuleCache.computeIfAbsent(moduleKey, x -> new HashMap()).put(file.getModuleRelativePath(), inputFile);
        this.inputModuleKeyByFileCache.put(inputFile, moduleKey);
        this.globalInputFileCache.put(file.getProjectRelativePath(), inputFile);
        this.inputComponents.put(inputFile.key(), (InputComponent)inputFile);
        this.filesByNameCache.computeIfAbsent(inputFile.filename(), x -> new LinkedHashSet()).add(inputFile);
        this.filesByExtensionCache.computeIfAbsent(FileExtensionPredicate.getExtension((InputFile)inputFile), x -> new LinkedHashSet()).add(inputFile);
        return this;
    }

    private void addToLanguageCache(String moduleKey, DefaultInputFile inputFile) {
        String language = inputFile.language();
        if (language != null) {
            this.globalLanguagesCache.add(language);
            this.languagesCache.computeIfAbsent(moduleKey, k -> new TreeSet()).add(language);
        }
    }

    @CheckForNull
    public InputFile getFile(String moduleKey, String relativePath) {
        return (InputFile)this.inputFileByModuleCache.getOrDefault(moduleKey, Collections.emptyMap()).get(relativePath);
    }

    @CheckForNull
    public InputFile inputFile(String relativePath) {
        return this.globalInputFileCache.get(relativePath);
    }

    public DefaultInputModule findModule(DefaultInputFile file) {
        return Optional.ofNullable(this.inputModuleKeyByFileCache.get(file)).map(this.inputModuleCache::get).orElseThrow(() -> new IllegalStateException("No modules for file '" + file.toString() + "'"));
    }

    public void put(DefaultInputModule inputModule) {
        String key = inputModule.key();
        Preconditions.checkNotNull((Object)inputModule);
        Preconditions.checkState((!this.inputComponents.containsKey(key) ? 1 : 0) != 0, (String)"Module '%s' already indexed", (Object[])new Object[]{key});
        Preconditions.checkState((!this.inputModuleCache.containsKey(key) ? 1 : 0) != 0, (String)"Module '%s' already indexed", (Object[])new Object[]{key});
        this.inputComponents.put(key, (InputComponent)inputModule);
        this.inputModuleCache.put(key, inputModule);
    }

    public Iterable<InputFile> getFilesByName(String filename) {
        return this.filesByNameCache.getOrDefault(filename, Collections.emptySet());
    }

    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.filesByExtensionCache.getOrDefault(extension, Collections.emptySet());
    }

    public SortedSet<String> languages() {
        return this.globalLanguagesCache;
    }

    public SortedSet<String> languages(String moduleKey) {
        return this.languagesCache.getOrDefault(moduleKey, Collections.emptySortedSet());
    }

    public Collection<DefaultInputModule> allModules() {
        return this.inputModuleCache.values();
    }

    protected void doAdd(InputFile inputFile) {
        throw new UnsupportedOperationException();
    }

    private void updateNotAnalysedCAndCppFileCount(DefaultInputFile inputFile) {
        if (!SonarEdition.COMMUNITY.equals((Object)this.sonarRuntime.getEdition())) {
            return;
        }
        FILE_PATTERN_BY_LANGUAGE.forEach((language, filePattern) -> {
            if (filePattern.matcher(inputFile.filename()).matches()) {
                this.notAnalysedFilesByLanguage.put(language.toString(), this.notAnalysedFilesByLanguage.getOrDefault(language.toString(), 0) + 1);
            }
        });
    }

    public Map<String, Integer> getNotAnalysedFilesByLanguage() {
        return ImmutableMap.copyOf(this.notAnalysedFilesByLanguage);
    }
}

