/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.sonar.scanner.scan.filesystem.ByteCharsetDetector;
import org.sonar.scanner.scan.filesystem.CharsetValidation;

public class CharsetDetector {
    private static final int BYTES_TO_DECODE = 4192;
    private final Path filePath;
    private BufferedInputStream stream;
    private Charset detectedCharset;
    private Charset userEncoding;

    public CharsetDetector(Path filePath, Charset userEncoding) {
        this.filePath = filePath;
        this.userEncoding = userEncoding;
    }

    public boolean run() {
        try {
            byte[] buf = this.readBuffer();
            return this.detectCharset(buf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file " + this.filePath.toAbsolutePath(), e);
        }
    }

    @CheckForNull
    public Charset charset() {
        this.assertRun();
        return this.detectedCharset;
    }

    public InputStream inputStream() {
        this.assertRun();
        return this.stream;
    }

    private byte[] readBuffer() throws IOException {
        this.stream = new BufferedInputStream(Files.newInputStream(this.filePath, new OpenOption[0]), 8384);
        this.stream.mark(4192);
        byte[] buf = new byte[4192];
        int read = IOUtils.read((InputStream)this.stream, (byte[])buf, (int)0, (int)4192);
        this.stream.reset();
        this.stream.mark(-1);
        return Arrays.copyOf(buf, read);
    }

    private boolean detectCharset(byte[] buf) throws IOException {
        ByteCharsetDetector detector = new ByteCharsetDetector(new CharsetValidation(), this.userEncoding);
        ByteOrderMark bom = detector.detectBOM(buf);
        if (bom != null) {
            this.detectedCharset = Charset.forName(bom.getCharsetName());
            this.stream.skip(bom.length());
            return true;
        }
        this.detectedCharset = detector.detect(buf);
        return this.detectedCharset != null;
    }

    private void assertRun() {
        if (this.stream == null) {
            throw new IllegalStateException("Charset detection did not run");
        }
    }
}

