/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import javax.annotation.Nullable;
import javax.annotation.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.issue.internal.DefaultNoSonarFilter;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.Preconditions;
import org.sonar.core.config.ScannerProperties;
import org.sonar.core.extension.CoreExtensionsInstaller;
import org.sonar.core.language.LanguagesProvider;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.core.platform.ExtensionContainer;
import org.sonar.core.platform.SpringComponentContainer;
import org.sonar.scanner.DefaultFileLinesContextFactory;
import org.sonar.scanner.ProjectInfo;
import org.sonar.scanner.analysis.AnalysisTempFolderProvider;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.PostJobExtensionDictionary;
import org.sonar.scanner.cache.AnalysisCacheEnabled;
import org.sonar.scanner.cache.AnalysisCacheMemoryStorage;
import org.sonar.scanner.cache.AnalysisCacheProvider;
import org.sonar.scanner.cache.DefaultAnalysisCacheLoader;
import org.sonar.scanner.ci.CiConfigurationProvider;
import org.sonar.scanner.ci.vendors.AppVeyor;
import org.sonar.scanner.ci.vendors.AwsCodeBuild;
import org.sonar.scanner.ci.vendors.AzureDevops;
import org.sonar.scanner.ci.vendors.Bamboo;
import org.sonar.scanner.ci.vendors.BitbucketPipelines;
import org.sonar.scanner.ci.vendors.Bitrise;
import org.sonar.scanner.ci.vendors.Buildkite;
import org.sonar.scanner.ci.vendors.CircleCi;
import org.sonar.scanner.ci.vendors.CirrusCi;
import org.sonar.scanner.ci.vendors.CodeMagic;
import org.sonar.scanner.ci.vendors.DroneCi;
import org.sonar.scanner.ci.vendors.GithubActions;
import org.sonar.scanner.ci.vendors.GitlabCi;
import org.sonar.scanner.ci.vendors.Jenkins;
import org.sonar.scanner.ci.vendors.SemaphoreCi;
import org.sonar.scanner.ci.vendors.TravisCi;
import org.sonar.scanner.cpd.CpdExecutor;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.issue.IssuePublisher;
import org.sonar.scanner.issue.ignore.EnforceIssuesFilter;
import org.sonar.scanner.issue.ignore.IgnoreIssuesFilter;
import org.sonar.scanner.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.mediumtest.AnalysisObservers;
import org.sonar.scanner.postjob.DefaultPostJobContext;
import org.sonar.scanner.postjob.PostJobOptimizer;
import org.sonar.scanner.postjob.PostJobsExecutor;
import org.sonar.scanner.qualitygate.QualityGateCheck;
import org.sonar.scanner.report.ActiveRulesPublisher;
import org.sonar.scanner.report.AnalysisCachePublisher;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.report.AnalysisWarningsPublisher;
import org.sonar.scanner.report.CeTaskReportDataHolder;
import org.sonar.scanner.report.ChangedLinesPublisher;
import org.sonar.scanner.report.ComponentsPublisher;
import org.sonar.scanner.report.ContextPropertiesPublisher;
import org.sonar.scanner.report.JavaArchitectureInformationProvider;
import org.sonar.scanner.report.MetadataPublisher;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.report.ScannerFileStructureProvider;
import org.sonar.scanner.report.SourcePublisher;
import org.sonar.scanner.report.TestExecutionPublisher;
import org.sonar.scanner.repository.ContextPropertiesCache;
import org.sonar.scanner.repository.DefaultProjectRepositoriesLoader;
import org.sonar.scanner.repository.DefaultQualityProfileLoader;
import org.sonar.scanner.repository.ProjectRepositoriesProvider;
import org.sonar.scanner.repository.QualityProfilesProvider;
import org.sonar.scanner.repository.ReferenceBranchSupplier;
import org.sonar.scanner.repository.language.DefaultLanguagesRepository;
import org.sonar.scanner.repository.settings.DefaultProjectSettingsLoader;
import org.sonar.scanner.rule.ActiveRulesProvider;
import org.sonar.scanner.rule.DefaultActiveRulesLoader;
import org.sonar.scanner.rule.DefaultRulesLoader;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.rule.RulesProvider;
import org.sonar.scanner.scan.DeprecatedPropertiesWarningGenerator;
import org.sonar.scanner.scan.InputModuleHierarchyProvider;
import org.sonar.scanner.scan.InputProjectProvider;
import org.sonar.scanner.scan.ModuleIndexer;
import org.sonar.scanner.scan.MutableProjectReactorProvider;
import org.sonar.scanner.scan.MutableProjectSettings;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectConfigurationProvider;
import org.sonar.scanner.scan.ProjectLock;
import org.sonar.scanner.scan.ProjectReactorBuilder;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.ProjectServerSettingsProvider;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.sonar.scanner.scan.SpringModuleScanContainer;
import org.sonar.scanner.scan.WorkDirectoriesInitializer;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationProvider;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scan.branch.ProjectBranchesProvider;
import org.sonar.scanner.scan.filesystem.DefaultProjectFileSystem;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectFileIndexer;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.sonar.scanner.scan.filesystem.StatusDetection;
import org.sonar.scanner.scan.measure.DefaultMetricFinder;
import org.sonar.scanner.scm.ScmChangedFilesProvider;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.scm.ScmPublisher;
import org.sonar.scanner.scm.ScmRevisionImpl;
import org.sonar.scanner.sensor.DefaultSensorStorage;
import org.sonar.scanner.sensor.ExecutingSensorContext;
import org.sonar.scanner.sensor.ProjectSensorContext;
import org.sonar.scanner.sensor.ProjectSensorExtensionDictionary;
import org.sonar.scanner.sensor.ProjectSensorOptimizer;
import org.sonar.scanner.sensor.ProjectSensorsExecutor;
import org.sonar.scanner.sensor.UnchangedFilesHandler;
import org.sonar.scm.git.GitScmSupport;
import org.sonar.scm.svn.SvnScmSupport;

@Priority(value=2)
public class SpringProjectScanContainer
extends SpringComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringProjectScanContainer.class);

    public SpringProjectScanContainer(SpringComponentContainer globalContainer) {
        super(globalContainer);
    }

    protected void doBeforeStart() {
        this.addScannerExtensions();
        this.addScannerComponents();
    }

    private void addScannerComponents() {
        this.add(new Object[]{ScanProperties.class, ProjectReactorBuilder.class, WorkDirectoriesInitializer.class, new MutableProjectReactorProvider(), ProjectBuildersExecutor.class, ProjectLock.class, ResourceTypes.class, ProjectReactorValidator.class, ProjectInfo.class, new RulesProvider(), new BranchConfigurationProvider(), new ProjectBranchesProvider(), ProjectRepositoriesProvider.class, new ProjectServerSettingsProvider(), AnalysisCacheEnabled.class, DeprecatedPropertiesWarningGenerator.class, new AnalysisTempFolderProvider(), ModuleIndexer.class, InputComponentStore.class, PathResolver.class, new InputProjectProvider(), new InputModuleHierarchyProvider(), ScannerComponentIdGenerator.class, new ScmChangedFilesProvider(), StatusDetection.class, LanguageDetection.class, MetadataGenerator.class, FileMetadata.class, FileIndexer.class, ProjectFileIndexer.class, ProjectExclusionFilters.class, new ActiveRulesProvider(), new QualityProfilesProvider(), CheckFactory.class, QProfileVerifier.class, DefaultNoSonarFilter.class, IssueFilters.class, IssuePublisher.class, DefaultMetricFinder.class, LanguagesProvider.class, DefaultLanguagesRepository.class, IssueInclusionPatternInitializer.class, IssueExclusionPatternInitializer.class, IssueExclusionsLoader.class, EnforceIssuesFilter.class, IgnoreIssuesFilter.class, ContextPropertiesCache.class, ContextPropertiesPublisher.class, SensorStrategy.class, MutableProjectSettings.class, ScannerProperties.class, SonarGlobalPropertiesFilter.class, ProjectConfigurationProvider.class, ProjectCoverageAndDuplicationExclusions.class, AnalysisCacheProvider.class, AnalysisCacheMemoryStorage.class, DefaultAnalysisCacheLoader.class, ReferenceBranchSupplier.class, ScannerMetrics.class, JavaArchitectureInformationProvider.class, ReportPublisher.class, ScannerFileStructureProvider.class, AnalysisContextReportPublisher.class, MetadataPublisher.class, ActiveRulesPublisher.class, ComponentsPublisher.class, AnalysisCachePublisher.class, TestExecutionPublisher.class, SourcePublisher.class, ChangedLinesPublisher.class, AnalysisWarningsPublisher.class, CeTaskReportDataHolder.class, QualityGateCheck.class, CpdExecutor.class, CpdSettings.class, SonarCpdBlockIndex.class, PostJobsExecutor.class, PostJobOptimizer.class, DefaultPostJobContext.class, PostJobExtensionDictionary.class, ScmConfiguration.class, ScmPublisher.class, ScmRevisionImpl.class, DefaultSensorStorage.class, DefaultFileLinesContextFactory.class, ProjectSensorContext.class, ProjectSensorOptimizer.class, ProjectSensorsExecutor.class, ExecutingSensorContext.class, ProjectSensorExtensionDictionary.class, UnchangedFilesHandler.class, DefaultProjectFileSystem.class, new CiConfigurationProvider(), AppVeyor.class, AwsCodeBuild.class, AzureDevops.class, Bamboo.class, BitbucketPipelines.class, Bitrise.class, Buildkite.class, CircleCi.class, CirrusCi.class, DroneCi.class, GithubActions.class, CodeMagic.class, GitlabCi.class, Jenkins.class, SemaphoreCi.class, TravisCi.class, AnalysisObservers.class});
        this.add(new Object[]{GitScmSupport.getObjects()});
        this.add(new Object[]{SvnScmSupport.getObjects()});
        this.add(new Object[]{DefaultProjectSettingsLoader.class, DefaultRulesLoader.class, DefaultActiveRulesLoader.class, DefaultQualityProfileLoader.class, DefaultProjectRepositoriesLoader.class});
    }

    private void addScannerExtensions() {
        Preconditions.checkNotNull((Object)this.getParent());
        ((CoreExtensionsInstaller)this.getParent().getComponentByType(CoreExtensionsInstaller.class)).install((ExtensionContainer)this, CoreExtensionsInstaller.noExtensionFilter(), extension -> SpringProjectScanContainer.getScannerProjectExtensionsFilter().accept(extension));
        ((ExtensionInstaller)this.getParent().getComponentByType(ExtensionInstaller.class)).install((ExtensionContainer)this, SpringProjectScanContainer.getScannerProjectExtensionsFilter());
    }

    static ExtensionMatcher getScannerProjectExtensionsFilter() {
        return extension -> {
            if (ExtensionUtils.isDeprecatedScannerSide(extension)) {
                return ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
            }
            return ExtensionUtils.isScannerSide(extension);
        };
    }

    protected void doAfterStart() {
        ((ProjectLock)this.getComponentByType(ProjectLock.class)).tryLock();
        GlobalAnalysisMode analysisMode = (GlobalAnalysisMode)this.getComponentByType(GlobalAnalysisMode.class);
        InputModuleHierarchy tree = (InputModuleHierarchy)this.getComponentByType(InputModuleHierarchy.class);
        ScanProperties properties = (ScanProperties)this.getComponentByType(ScanProperties.class);
        properties.validate();
        properties.get("sonar.branch").ifPresent(deprecatedBranch -> {
            throw MessageException.of((String)"The 'sonar.branch' parameter is no longer supported. You should stop using it. Branch analysis is available in Developer Edition and above. See https://www.sonarsource.com/plans-and-pricing/developer/ for more information.");
        });
        BranchConfiguration branchConfig = (BranchConfiguration)this.getComponentByType(BranchConfiguration.class);
        if (branchConfig.branchType() == BranchType.PULL_REQUEST) {
            LOG.info("Pull request {} for merge into {} from {}", new Object[]{branchConfig.pullRequestKey(), SpringProjectScanContainer.pullRequestBaseToDisplayName(branchConfig.targetBranchName()), branchConfig.branchName()});
        } else if (branchConfig.branchName() != null) {
            LOG.info("Branch name: {}", (Object)branchConfig.branchName());
        }
        ((DeprecatedPropertiesWarningGenerator)this.getComponentByType(DeprecatedPropertiesWarningGenerator.class)).execute();
        ((ProjectFileIndexer)this.getComponentByType(ProjectFileIndexer.class)).index();
        ((QProfileVerifier)this.getComponentByType(QProfileVerifier.class)).execute();
        this.scanRecursively(tree, tree.root());
        LOG.info("------------- Run sensors on project");
        ((ProjectSensorsExecutor)this.getComponentByType(ProjectSensorsExecutor.class)).execute();
        ((ScmPublisher)this.getComponentByType(ScmPublisher.class)).publish();
        ((CpdExecutor)this.getComponentByType(CpdExecutor.class)).execute();
        ((ReportPublisher)this.getComponentByType(ReportPublisher.class)).execute();
        if (properties.shouldWaitForQualityGate()) {
            LOG.info("------------- Check Quality Gate status");
            ((QualityGateCheck)this.getComponentByType(QualityGateCheck.class)).await();
        }
        ((PostJobsExecutor)this.getComponentByType(PostJobsExecutor.class)).execute();
        if (analysisMode.isMediumTest()) {
            ((AnalysisObservers)this.getComponentByType(AnalysisObservers.class)).notifyEndOfScanTask();
        }
    }

    private static String pullRequestBaseToDisplayName(@Nullable String pullRequestBase) {
        return pullRequestBase != null ? pullRequestBase : "default branch";
    }

    private void scanRecursively(InputModuleHierarchy tree, DefaultInputModule module) {
        for (DefaultInputModule child : tree.children(module)) {
            this.scanRecursively(tree, child);
        }
        LOG.info("------------- Run sensors on module {}", (Object)module.definition().getName());
        this.scan(module);
    }

    void scan(DefaultInputModule module) {
        new SpringModuleScanContainer(this, module).execute();
    }
}

