/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.internal.MultivalueProperty;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;

public class ProjectReactorBuilder {
    private static final String INVALID_VALUE_OF_X_FOR_Y = "Invalid value of {0} for {1}";
    private static final Logger LOG = Loggers.get(ProjectReactorBuilder.class);
    @VisibleForTesting
    static final String WILDCARDS_NOT_SUPPORTED = "Wildcards ** and * are not supported in \"sonar.sources\" and \"sonar.tests\" properties. \"sonar.sources\" and \"sonar.tests\" properties support only comma separated list of directories. Use \"sonar.exclusions/sonar.inclusions\" and \"sonar.test.exclusions/sonar.test.inclusions\" to further filter files in \"sonar.sources\" and \"sonar.tests\" respectively. Please refer to SonarQube documentation for more details.";
    private static final String MODULE_KEY_PROPERTY = "sonar.moduleKey";
    protected static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_SOURCES = "sonar.sources";
    private static final String PROPERTY_TESTS = "sonar.tests";
    private static final String[] MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey"};
    private static final String[] MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey"};
    private static final String[] MANDATORY_PROPERTIES_FOR_CHILD = new String[]{"sonar.moduleKey"};
    private static final Collection<String> UNSUPPORTED_PROPS_FOR_MODULES = Arrays.asList("sonar.issue.ignore.multicriteria", "sonar.issue.enforce.multicriteria", "sonar.issue.ignore.block", "sonar.issue.ignore.allfile");
    private static final List<String> NON_HERITED_PROPERTIES_FOR_CHILD = Stream.concat(Stream.of("sonar.projectBaseDir", "sonar.working.directory", "sonar.modules", "sonar.projectDescription"), UNSUPPORTED_PROPS_FOR_MODULES.stream()).collect(Collectors.toList());
    private final ScannerProperties scannerProps;
    private final AnalysisWarnings analysisWarnings;
    private File rootProjectWorkDir;
    private boolean warnExclusionsAlreadyLogged;

    public ProjectReactorBuilder(ScannerProperties props, AnalysisWarnings analysisWarnings) {
        this.scannerProps = props;
        this.analysisWarnings = analysisWarnings;
    }

    public ProjectReactor execute() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Process project properties");
        HashMap<String, Map<String, String>> propertiesByModuleIdPath = new HashMap<String, Map<String, String>>();
        ProjectReactorBuilder.extractPropertiesByModule(propertiesByModuleIdPath, "", "", new HashMap<String, String>(this.scannerProps.properties()));
        ProjectDefinition rootProject = this.createModuleDefinition((Map)propertiesByModuleIdPath.get(""), null);
        this.rootProjectWorkDir = rootProject.getWorkDir();
        this.defineChildren(rootProject, propertiesByModuleIdPath, "");
        ProjectReactorBuilder.cleanAndCheckProjectDefinitions(rootProject);
        profiler.stopInfo();
        return new ProjectReactor(rootProject);
    }

    private static void extractPropertiesByModule(Map<String, Map<String, String>> propertiesByModuleIdPath, String currentModuleId, String currentModuleIdPath, Map<String, String> parentProperties) {
        if (propertiesByModuleIdPath.containsKey(currentModuleIdPath)) {
            throw MessageException.of((String)String.format("Two modules have the same id: '%s'. Each module must have a unique id.", currentModuleId));
        }
        HashMap<String, String> currentModuleProperties = new HashMap<String, String>();
        Object prefix = !currentModuleId.isEmpty() ? currentModuleId + "." : "";
        int prefixLength = ((String)prefix).length();
        Iterator<Map.Entry<String, String>> it = parentProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String key = e.getKey();
            if (!key.startsWith((String)prefix)) continue;
            currentModuleProperties.put(key.substring(prefixLength), e.getValue());
            it.remove();
        }
        Object[] moduleIds = ProjectReactorBuilder.getListFromProperty(currentModuleProperties, PROPERTY_MODULES);
        Arrays.sort(moduleIds);
        ArrayUtils.reverse((Object[])moduleIds);
        propertiesByModuleIdPath.put(currentModuleIdPath, currentModuleProperties);
        for (Object moduleId : moduleIds) {
            if ("sonar".equals(moduleId)) {
                throw MessageException.of((String)"'sonar' is not a valid module id. Please check property 'sonar.modules'.");
            }
            Object subModuleIdPath = currentModuleIdPath.isEmpty() ? moduleId : currentModuleIdPath + "." + (String)moduleId;
            ProjectReactorBuilder.extractPropertiesByModule(propertiesByModuleIdPath, (String)moduleId, (String)subModuleIdPath, currentModuleProperties);
        }
    }

    protected ProjectDefinition createModuleDefinition(Map<String, String> moduleProperties, @Nullable ProjectDefinition parent) {
        File workDir;
        if (moduleProperties.containsKey(PROPERTY_MODULES)) {
            ProjectReactorBuilder.checkMandatoryProperties(moduleProperties, MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT);
        } else {
            ProjectReactorBuilder.checkMandatoryProperties(moduleProperties, MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT);
        }
        File baseDir = new File(moduleProperties.get(PROPERTY_PROJECT_BASEDIR));
        String projectKey = moduleProperties.get("sonar.projectKey");
        if (parent == null) {
            ProjectReactorBuilder.validateDirectories(moduleProperties, baseDir, projectKey);
            workDir = this.initRootProjectWorkDir(baseDir, moduleProperties);
        } else {
            workDir = this.initModuleWorkDir(baseDir, moduleProperties);
            this.checkUnsupportedIssueExclusions(moduleProperties, parent.properties());
        }
        return ProjectDefinition.create().setProperties(moduleProperties).setBaseDir(baseDir).setWorkDir(workDir);
    }

    private void checkUnsupportedIssueExclusions(Map<String, String> moduleProperties, Map<String, String> parentProps) {
        UNSUPPORTED_PROPS_FOR_MODULES.forEach(p -> {
            if (moduleProperties.containsKey(p) && !Objects.equals(moduleProperties.get(p), parentProps.get(p))) {
                this.warnOnceUnsupportedIssueExclusions("Specifying issue exclusions at module level is not supported anymore. Configure the property '" + p + "' and any other issue exclusions at project level.");
            }
        });
    }

    private void warnOnceUnsupportedIssueExclusions(String msg) {
        if (!this.warnExclusionsAlreadyLogged) {
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            this.warnExclusionsAlreadyLogged = true;
        }
    }

    protected File initRootProjectWorkDir(File baseDir, Map<String, String> rootProperties) {
        String workDir = rootProperties.get("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(baseDir, ".sonar");
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(baseDir, customWorkDir.getPath());
    }

    protected File initModuleWorkDir(File moduleBaseDir, Map<String, String> moduleProperties) {
        String workDir = moduleProperties.get("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(this.rootProjectWorkDir, ScannerUtils.cleanKeyForFilename((String)moduleProperties.get("sonar.projectKey")));
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(moduleBaseDir, customWorkDir.getPath());
    }

    private void defineChildren(ProjectDefinition parentProject, Map<String, Map<String, String>> propertiesByModuleIdPath, String parentModuleIdPath) {
        Map parentProps = parentProject.properties();
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String moduleId : ProjectReactorBuilder.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                String moduleIdPath = parentModuleIdPath.isEmpty() ? moduleId : parentModuleIdPath + "." + moduleId;
                Map<String, String> moduleProps = propertiesByModuleIdPath.get(moduleIdPath);
                ProjectDefinition childProject = this.loadChildProject(parentProject, moduleProps, moduleId);
                ProjectReactorBuilder.checkUniquenessOfChildKey(childProject, parentProject);
                this.defineChildren(childProject, propertiesByModuleIdPath, moduleIdPath);
                parentProject.addSubProject(childProject);
            }
        }
    }

    protected ProjectDefinition loadChildProject(ProjectDefinition parentProject, Map<String, String> moduleProps, String moduleId) {
        File baseDir;
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            baseDir = ProjectReactorBuilder.resolvePath(parentProject.getBaseDir(), moduleProps.get(PROPERTY_PROJECT_BASEDIR));
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        } else {
            baseDir = new File(parentProject.getBaseDir(), moduleId);
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        }
        ProjectReactorBuilder.setModuleKeyAndNameIfNotDefined(moduleProps, moduleId, parentProject.getKey());
        ProjectReactorBuilder.checkMandatoryProperties(moduleProps, MANDATORY_PROPERTIES_FOR_CHILD);
        ProjectReactorBuilder.validateDirectories(moduleProps, baseDir, moduleId);
        ProjectReactorBuilder.mergeParentProperties(moduleProps, parentProject.properties());
        return this.createModuleDefinition(moduleProps, parentProject);
    }

    protected static void setModuleKeyAndNameIfNotDefined(Map<String, String> childProps, String moduleId, String parentKey) {
        if (!childProps.containsKey(MODULE_KEY_PROPERTY)) {
            if (!childProps.containsKey("sonar.projectKey")) {
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + moduleId);
            } else {
                String childKey = childProps.get("sonar.projectKey");
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + childKey);
            }
        }
        childProps.putIfAbsent("sonar.projectName", moduleId);
        childProps.put("sonar.projectKey", childProps.get(MODULE_KEY_PROPERTY));
    }

    protected static void checkUniquenessOfChildKey(ProjectDefinition childProject, ProjectDefinition parentProject) {
        for (ProjectDefinition definition : parentProject.getSubProjects()) {
            if (!definition.getKey().equals(childProject.getKey())) continue;
            throw MessageException.of((String)("Project '" + parentProject.getKey() + "' can't have 2 modules with the following key: " + childProject.getKey()));
        }
    }

    protected static void setProjectBaseDir(File baseDir, Map<String, String> childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw MessageException.of((String)("The base directory of the module '" + moduleId + "' does not exist: " + baseDir.getAbsolutePath()));
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    protected static void checkMandatoryProperties(Map<String, String> props, String[] mandatoryProps) {
        StringBuilder missing = new StringBuilder();
        for (String mandatoryProperty : mandatoryProps) {
            if (props.containsKey(mandatoryProperty)) continue;
            if (missing.length() > 0) {
                missing.append(", ");
            }
            missing.append(mandatoryProperty);
        }
        String moduleKey = StringUtils.defaultIfBlank((String)props.get(MODULE_KEY_PROPERTY), (String)props.get("sonar.projectKey"));
        if (missing.length() != 0) {
            throw MessageException.of((String)("You must define the following mandatory properties for '" + (moduleKey == null ? "Unknown" : moduleKey) + "': " + missing));
        }
    }

    protected static void validateDirectories(Map<String, String> props, File baseDir, String projectId) {
        if (!props.containsKey(PROPERTY_MODULES)) {
            String[] testPaths = ProjectReactorBuilder.getListFromProperty(props, PROPERTY_TESTS);
            ProjectReactorBuilder.checkExistenceAndValidateSourcePaths(projectId, baseDir, testPaths, PROPERTY_TESTS);
        }
    }

    protected static void cleanAndCheckProjectDefinitions(ProjectDefinition project) {
        if (project.getSubProjects().isEmpty()) {
            ProjectReactorBuilder.cleanAndCheckModuleProperties(project);
        } else {
            ProjectReactorBuilder.logMissingSourcesAndTests(project);
            for (ProjectDefinition module : project.getSubProjects()) {
                ProjectReactorBuilder.cleanAndCheckProjectDefinitions(module);
            }
        }
    }

    private static void logMissingSourcesAndTests(ProjectDefinition project) {
        Map properties = project.properties();
        File baseDir = project.getBaseDir();
        ProjectReactorBuilder.logMissingPaths("source", baseDir, ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES));
        ProjectReactorBuilder.logMissingPaths("test", baseDir, ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_TESTS));
    }

    private static void logMissingPaths(String label, File baseDir, String[] paths) {
        for (String path : paths) {
            File file = ProjectReactorBuilder.resolvePath(baseDir, path);
            if (file.exists()) continue;
            LOG.debug("Path '{}' does not exist, will not be used as {}", (Object)file, (Object)label);
        }
    }

    protected static void cleanAndCheckModuleProperties(ProjectDefinition project) {
        Map properties = project.properties();
        String[] sourcePaths = ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES);
        ProjectReactorBuilder.checkExistenceAndValidateSourcePaths(project.getKey(), project.getBaseDir(), sourcePaths, PROPERTY_SOURCES);
    }

    protected static void mergeParentProperties(Map<String, String> childProps, Map<String, String> parentProps) {
        for (Map.Entry<String, String> entry : parentProps.entrySet()) {
            String key = entry.getKey();
            if (childProps.containsKey(key) && !childProps.get(key).equals(entry.getValue()) || NON_HERITED_PROPERTIES_FOR_CHILD.contains(key)) continue;
            childProps.put(entry.getKey(), entry.getValue());
        }
    }

    protected static void checkExistenceAndValidateSourcePaths(String moduleRef, File baseDir, String[] paths, String propName) {
        for (String path : paths) {
            ProjectReactorBuilder.validateNoAsterisksInSourcePath(path, propName, moduleRef);
            File sourceFolder = ProjectReactorBuilder.resolvePath(baseDir, path);
            if (sourceFolder.exists()) continue;
            LOG.error(MessageFormat.format(INVALID_VALUE_OF_X_FOR_Y, propName, moduleRef));
            throw MessageException.of((String)("The folder '" + path + "' does not exist for '" + moduleRef + "' (base directory = " + baseDir.getAbsolutePath() + ")"));
        }
    }

    private static void validateNoAsterisksInSourcePath(String path, String propName, String moduleRef) {
        if (path.contains("*")) {
            LOG.error(MessageFormat.format(INVALID_VALUE_OF_X_FOR_Y, propName, moduleRef));
            throw MessageException.of((String)WILDCARDS_NOT_SUPPORTED);
        }
    }

    protected static File resolvePath(File baseDir, String path) {
        Path filePath = Paths.get(path, new String[0]);
        if (!filePath.isAbsolute()) {
            filePath = baseDir.toPath().resolve(path);
        }
        return filePath.normalize().toFile();
    }

    static String[] getListFromProperty(Map<String, String> properties, String key) {
        String propValue = properties.get(key);
        if (propValue != null) {
            return MultivalueProperty.parseAsCsv((String)key, (String)propValue);
        }
        return new String[0];
    }
}

