/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryLock.class);
    public static final String LOCK_FILE_NAME = ".sonar_lock";
    private final Path lockFilePath;
    private RandomAccessFile lockRandomAccessFile;
    private FileChannel lockChannel;
    private FileLock lockFile;

    public DirectoryLock(Path directory) {
        this.lockFilePath = directory.resolve(LOCK_FILE_NAME).toAbsolutePath();
    }

    public boolean tryLock() {
        try {
            this.lockRandomAccessFile = new RandomAccessFile(this.lockFilePath.toFile(), "rw");
            this.lockChannel = this.lockRandomAccessFile.getChannel();
            this.lockFile = this.lockChannel.tryLock(0L, 1024L, false);
            return this.lockFile != null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create lock in " + this.lockFilePath.toString(), e);
        }
    }

    public void unlock() {
        if (this.lockFile != null) {
            try {
                this.lockFile.release();
                this.lockFile = null;
            }
            catch (IOException e) {
                LOGGER.error("Error releasing lock", (Throwable)e);
            }
        }
        if (this.lockChannel != null) {
            try {
                this.lockChannel.close();
                this.lockChannel = null;
            }
            catch (IOException e) {
                LOGGER.error("Error closing file channel", (Throwable)e);
            }
        }
        if (this.lockRandomAccessFile != null) {
            try {
                this.lockRandomAccessFile.close();
                this.lockRandomAccessFile = null;
            }
            catch (IOException e) {
                LOGGER.error("Error closing file", (Throwable)e);
            }
        }
    }
}

