/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class DeprecatedPropertiesWarningGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecatedPropertiesWarningGenerator.class);
    @VisibleForTesting
    static final String PASSWORD_WARN_MESSAGE = String.format("The properties '%s' and '%s' are deprecated and will be removed in the future. Please pass a token with the '%s' property instead.", "sonar.login", "sonar.password", "sonar.token");
    @VisibleForTesting
    static final String LOGIN_WARN_MESSAGE = String.format("The property '%s' is deprecated and will be removed in the future. Please use the '%s' property instead when passing a token.", "sonar.login", "sonar.token");
    @VisibleForTesting
    static final String SCANNER_DOTNET_WARN_MESSAGE = String.format(" The '%s' property is available from SonarScanner for .NET version 5.13.", "sonar.token");
    private static final String ENV_KEY_SCANNER_DOTNET = "ScannerMSBuild";
    private final Configuration configuration;
    private final AnalysisWarnings analysisWarnings;
    private final EnvironmentInformation environmentInformation;

    public DeprecatedPropertiesWarningGenerator(Configuration configuration, AnalysisWarnings analysisWarnings, EnvironmentInformation environmentInformation) {
        this.configuration = configuration;
        this.analysisWarnings = analysisWarnings;
        this.environmentInformation = environmentInformation;
    }

    public void execute() {
        Optional login = this.configuration.get("sonar.login");
        Optional password = this.configuration.get("sonar.password");
        Object warningMessage = null;
        if (password.isPresent()) {
            warningMessage = PASSWORD_WARN_MESSAGE;
        } else if (login.isPresent()) {
            warningMessage = LOGIN_WARN_MESSAGE;
        }
        if (warningMessage != null) {
            if (this.isScannerDotNet()) {
                warningMessage = (String)warningMessage + SCANNER_DOTNET_WARN_MESSAGE;
            }
            LOG.warn((String)warningMessage);
            this.analysisWarnings.addUnique((String)warningMessage);
        }
    }

    private boolean isScannerDotNet() {
        return StringUtils.containsIgnoreCase((String)this.environmentInformation.getKey(), (String)ENV_KEY_SCANNER_DOTNET);
    }
}

