/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.rule.QProfile;
import org.sonarqube.ws.Qualityprofiles;

@Immutable
public class QualityProfiles {
    private final Map<String, QProfile> byLanguage;

    public QualityProfiles(Collection<Qualityprofiles.SearchWsResponse.QualityProfile> profiles) {
        HashMap<String, QProfile> map = new HashMap<String, QProfile>(profiles.size());
        for (Qualityprofiles.SearchWsResponse.QualityProfile qProfile : profiles) {
            map.put(qProfile.getLanguage(), new QProfile.Builder().setKey(qProfile.getKey()).setName(qProfile.getName()).setLanguage(qProfile.getLanguage()).setRulesUpdatedAt(DateUtils.parseDateTime((String)qProfile.getRulesUpdatedAt())).build());
        }
        this.byLanguage = Collections.unmodifiableMap(map);
    }

    public Collection<QProfile> findAll() {
        return this.byLanguage.values();
    }

    @CheckForNull
    public QProfile findByLanguage(String language) {
        return this.byLanguage.get(language);
    }
}

