/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.settings;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonarqube.ws.Settings;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsRequest;

public abstract class AbstractSettingsLoader {
    private static final Logger LOG = Loggers.get(AbstractSettingsLoader.class);
    private final DefaultScannerWsClient wsClient;

    public AbstractSettingsLoader(DefaultScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    Map<String, String> load(@Nullable String componentKey) {
        Map<String, String> map;
        block12: {
            Object url = "api/settings/values.protobuf";
            Profiler profiler = Profiler.create((Logger)LOG);
            if (componentKey != null) {
                url = (String)url + "?component=" + ScannerUtils.encodeForUrl((String)componentKey);
                profiler.startInfo(String.format("Load project settings for component key: '%s'", componentKey));
            } else {
                profiler.startInfo("Load global settings");
            }
            InputStream is = this.wsClient.call((WsRequest)new GetRequest((String)url)).contentStream();
            try {
                Settings.ValuesWsResponse values = Settings.ValuesWsResponse.parseFrom((InputStream)is);
                profiler.stopInfo();
                map = AbstractSettingsLoader.toMap(values.getSettingsList());
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpException e) {
                    if (e.code() == 404) {
                        return Collections.emptyMap();
                    }
                    throw e;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load settings", e);
                }
            }
            is.close();
        }
        return map;
    }

    static Map<String, String> toMap(List<Settings.Setting> settingsList) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        block5: for (Settings.Setting s : settingsList) {
            if (s.getInherited()) continue;
            switch (s.getValueOneOfCase()) {
                case VALUE: {
                    result.put(s.getKey(), s.getValue());
                    continue block5;
                }
                case VALUES: {
                    result.put(s.getKey(), s.getValues().getValuesList().stream().map(StringEscapeUtils::escapeCsv).collect(Collectors.joining(",")));
                    continue block5;
                }
                case FIELDVALUES: {
                    AbstractSettingsLoader.convertPropertySetToProps(result, s);
                    continue block5;
                }
            }
            if (s.getKey().endsWith(".secured")) continue;
            throw new IllegalStateException("Unknown property value for " + s.getKey());
        }
        return result;
    }

    private static void convertPropertySetToProps(Map<String, String> result, Settings.Setting s) {
        ArrayList<String> ids = new ArrayList<String>();
        int id = 1;
        for (Settings.FieldValues.Value v : s.getFieldValues().getFieldValuesList()) {
            for (Map.Entry entry : v.getValueMap().entrySet()) {
                result.put(s.getKey() + "." + id + "." + (String)entry.getKey(), (String)entry.getValue());
            }
            ids.add(String.valueOf(id));
            ++id;
        }
        result.put(s.getKey(), String.join((CharSequence)",", ids));
    }
}

