/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.language;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.Startable;
import org.sonar.api.resources.Languages;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesRepository;

@Immutable
public class DefaultLanguagesRepository
implements LanguagesRepository,
Startable {
    private final Languages languages;

    public DefaultLanguagesRepository(Languages languages) {
        this.languages = languages;
    }

    public void start() {
        if (this.languages.all().length == 0) {
            throw new IllegalStateException("No language plugins are installed.");
        }
    }

    @Override
    @CheckForNull
    public Language get(String languageKey) {
        org.sonar.api.resources.Language language = this.languages.get(languageKey);
        return language != null ? new Language(language) : null;
    }

    @Override
    public Collection<Language> all() {
        return Arrays.stream(this.languages.all()).map(Language::new).collect(Collectors.toList());
    }

    public void stop() {
    }
}

