/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.springframework.context.annotation.Bean;

public class ProjectRepositoriesProvider {
    private static final Logger LOG = Loggers.get(ProjectRepositoriesProvider.class);
    private static final String LOG_MSG = "Load project repositories";
    private final ProjectRepositoriesLoader loader;
    private final ScannerProperties scannerProperties;
    private final BranchConfiguration branchConfig;

    public ProjectRepositoriesProvider(ProjectRepositoriesLoader loader, ScannerProperties scannerProperties, BranchConfiguration branchConfig) {
        this.loader = loader;
        this.scannerProperties = scannerProperties;
        this.branchConfig = branchConfig;
    }

    @Bean
    public ProjectRepositories projectRepositories() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
        ProjectRepositories project = this.loader.load(this.scannerProperties.getProjectKey(), this.branchConfig.referenceBranchName());
        profiler.stopInfo();
        return project;
    }
}

