/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.MultiModuleProjectRepository;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.repository.SingleProjectRepository;
import org.sonarqube.ws.Batch;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class DefaultProjectRepositoriesLoader
implements ProjectRepositoriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectRepositoriesLoader.class);
    private static final String BATCH_PROJECT_URL = "/batch/project.protobuf";
    private final DefaultScannerWsClient wsClient;

    public DefaultProjectRepositoriesLoader(DefaultScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectRepositories load(String projectKey, @Nullable String branchBase) {
        GetRequest request = new GetRequest(DefaultProjectRepositoriesLoader.getUrl(projectKey, branchBase));
        try (WsResponse response = this.wsClient.call((WsRequest)request);){
            ProjectRepositories projectRepositories;
            block17: {
                InputStream is = response.contentStream();
                try {
                    projectRepositories = DefaultProjectRepositoriesLoader.processStream(is);
                    if (is == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Couldn't load project repository for " + projectKey, e);
                    }
                }
                is.close();
            }
            return projectRepositories;
        }
        catch (RuntimeException e) {
            if (DefaultProjectRepositoriesLoader.shouldThrow(e)) {
                throw e;
            }
            LOG.debug("Project repository not available - continuing without it");
            return new SingleProjectRepository();
        }
    }

    private static String getUrl(String projectKey, @Nullable String branchBase) {
        StringBuilder builder = new StringBuilder();
        builder.append(BATCH_PROJECT_URL).append("?key=").append(ScannerUtils.encodeForUrl((String)projectKey));
        if (branchBase != null) {
            builder.append("&branch=").append(branchBase);
        }
        return builder.toString();
    }

    private static boolean shouldThrow(Exception e) {
        Throwable t = e;
        do {
            if (!(t instanceof HttpException) || ((HttpException)t).code() != 404) continue;
            return false;
        } while ((t = t.getCause()) != null);
        return true;
    }

    private static ProjectRepositories processStream(InputStream is) throws IOException {
        Batch.WsProjectResponse response = Batch.WsProjectResponse.parseFrom((InputStream)is);
        if (response.getFileDataByModuleAndPathCount() == 0) {
            return new SingleProjectRepository(DefaultProjectRepositoriesLoader.constructFileDataMap(response.getFileDataByPathMap()));
        }
        HashMap<String, SingleProjectRepository> repositoriesPerModule = new HashMap<String, SingleProjectRepository>();
        response.getFileDataByModuleAndPathMap().keySet().forEach(moduleKey -> {
            Batch.WsProjectResponse.FileDataByPath filePaths = (Batch.WsProjectResponse.FileDataByPath)response.getFileDataByModuleAndPathMap().get(moduleKey);
            repositoriesPerModule.put((String)moduleKey, new SingleProjectRepository(DefaultProjectRepositoriesLoader.constructFileDataMap(filePaths.getFileDataByPathMap())));
        });
        return new MultiModuleProjectRepository(repositoriesPerModule);
    }

    private static Map<String, FileData> constructFileDataMap(Map<String, Batch.WsProjectResponse.FileData> content) {
        HashMap<String, FileData> fileDataMap = new HashMap<String, FileData>();
        content.forEach((key, value) -> {
            FileData fd = new FileData(value.getHash(), value.getRevision());
            fileDataMap.put((String)key, fd);
        });
        return fileDataMap;
    }
}

