/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.measures.Metric;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.protocol.GsonHelper;
import org.sonar.scanner.repository.MetricsRepository;
import org.sonar.scanner.repository.MetricsRepositoryLoader;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultMetricsRepositoryLoader
implements MetricsRepositoryLoader {
    private static final String METRICS_SEARCH_URL = "/api/metrics/search?ps=500&p=";
    private DefaultScannerWsClient wsClient;

    public DefaultMetricsRepositoryLoader(DefaultScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public MetricsRepository load() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        try {
            this.loadFromPaginatedWs(metrics);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load metrics", e);
        }
        return new MetricsRepository(metrics);
    }

    private void loadFromPaginatedWs(List<Metric> metrics) throws IOException {
        WsMetricsResponse response;
        int page = 1;
        do {
            GetRequest getRequest = new GetRequest(METRICS_SEARCH_URL + page);
            try (Reader reader = this.wsClient.call((WsRequest)getRequest).contentReader();){
                response = (WsMetricsResponse)GsonHelper.create().fromJson(reader, WsMetricsResponse.class);
                for (WsMetric metric : response.metrics) {
                    metrics.add(new Metric.Builder(metric.getKey(), metric.getName(), Metric.ValueType.valueOf((String)metric.getType())).create().setDirection(Integer.valueOf(metric.getDirection())).setQualitative(Boolean.valueOf(metric.isQualitative())).setUserManaged(Boolean.valueOf(false)).setDescription(metric.getDescription()).setUuid(metric.getUuid()));
                }
            }
            ++page;
        } while (response.getP() < response.getTotal() / response.getPs() + 1);
    }

    private static class WsMetricsResponse {
        private List<WsMetric> metrics = new ArrayList<WsMetric>();
        private int total;
        private int p;
        private int ps;

        public int getTotal() {
            return this.total;
        }

        public int getP() {
            return this.p;
        }

        public int getPs() {
            return this.ps;
        }
    }

    private static class WsMetric {
        private String uuid;
        private String key;
        private String type;
        private String name;
        private String description;
        private int direction;
        private boolean qualitative;

        private WsMetric() {
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getDirection() {
            return this.direction;
        }

        public boolean isQualitative() {
            return this.qualitative;
        }
    }
}

