/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.scanner.notifications.DefaultAnalysisWarnings;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;

public class AnalysisWarningsPublisher
implements ReportPublisherStep {
    private final DefaultAnalysisWarnings defaultAnalysisWarnings;

    public AnalysisWarningsPublisher(DefaultAnalysisWarnings defaultAnalysisWarnings) {
        this.defaultAnalysisWarnings = defaultAnalysisWarnings;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        List<DefaultAnalysisWarnings.Message> warnings = this.defaultAnalysisWarnings.warnings();
        if (warnings.isEmpty()) {
            return;
        }
        writer.writeAnalysisWarnings((Iterable)warnings.stream().map(AnalysisWarningsPublisher::toProtobufAnalysisWarning).collect(Collectors.toList()));
    }

    private static ScannerReport.AnalysisWarning toProtobufAnalysisWarning(DefaultAnalysisWarnings.Message message) {
        return ScannerReport.AnalysisWarning.newBuilder().setText(message.getText()).setTimestamp(message.getTimestamp()).build();
    }
}

