/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.utils.System2;
import org.sonar.core.platform.PluginInfo;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class AnalysisContextReportPublisher {
    private static final String KEY_VALUE_FORMAT = "  - %s=%s";
    private static final String ENV_PROP_PREFIX = "env.";
    private static final String SONAR_PROP_PREFIX = "sonar.";
    private static final int MAX_WIDTH = 1000;
    private final ScannerPluginRepository pluginRepo;
    private final ProjectServerSettings projectServerSettings;
    private final System2 system;
    private final GlobalServerSettings globalServerSettings;
    private final InputModuleHierarchy hierarchy;
    private final InputComponentStore store;

    public AnalysisContextReportPublisher(ProjectServerSettings projectServerSettings, ScannerPluginRepository pluginRepo, System2 system, GlobalServerSettings globalServerSettings, InputModuleHierarchy hierarchy, InputComponentStore store) {
        this.projectServerSettings = projectServerSettings;
        this.pluginRepo = pluginRepo;
        this.system = system;
        this.globalServerSettings = globalServerSettings;
        this.hierarchy = hierarchy;
        this.store = store;
    }

    public void init(ScannerReportWriter writer) {
        File analysisLog = writer.getFileStructure().analysisLog();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(analysisLog.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.writePlugins(fileWriter);
            this.writeBundledAnalyzers(fileWriter);
            this.writeGlobalSettings(fileWriter);
            this.writeProjectSettings(fileWriter);
            this.writeModulesSettings(fileWriter);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write analysis log", e);
        }
    }

    private void writePlugins(BufferedWriter fileWriter) throws IOException {
        fileWriter.write("Plugins:\n");
        for (PluginInfo p : this.pluginRepo.getExternalPluginsInfos()) {
            fileWriter.append(String.format("  - %s %s (%s)", p.getName(), p.getVersion(), p.getKey())).append('\n');
        }
    }

    private void writeBundledAnalyzers(BufferedWriter fileWriter) throws IOException {
        fileWriter.write("Bundled analyzers:\n");
        for (PluginInfo p : this.pluginRepo.getBundledPluginsInfos()) {
            fileWriter.append(String.format("  - %s %s (%s)", p.getName(), p.getVersion(), p.getKey())).append('\n');
        }
    }

    private void writeGlobalSettings(BufferedWriter fileWriter) throws IOException {
        fileWriter.append("Global server settings:\n");
        Map<String, String> props = this.globalServerSettings.properties();
        for (String prop : new TreeSet<String>(props.keySet())) {
            AnalysisContextReportPublisher.dumpPropIfNotSensitive(fileWriter, prop, props.get(prop));
        }
    }

    private void writeProjectSettings(BufferedWriter fileWriter) throws IOException {
        fileWriter.append("Project server settings:\n");
        Map<String, String> props = this.projectServerSettings.properties();
        for (String prop : new TreeSet<String>(props.keySet())) {
            AnalysisContextReportPublisher.dumpPropIfNotSensitive(fileWriter, prop, props.get(prop));
        }
        fileWriter.append("Project scanner properties:\n");
        this.writeScannerProps(fileWriter, this.hierarchy.root().properties());
    }

    private void writeModulesSettings(BufferedWriter fileWriter) throws IOException {
        for (DefaultInputModule module : this.store.allModules()) {
            if (module.equals((Object)this.hierarchy.root())) continue;
            Map<String, String> moduleSpecificProps = this.collectModuleSpecificProps(module);
            fileWriter.append(String.format("Scanner properties of module: %s", module.key())).append('\n');
            this.writeScannerProps(fileWriter, moduleSpecificProps);
        }
    }

    private void writeScannerProps(BufferedWriter fileWriter, Map<String, String> props) throws IOException {
        for (Map.Entry prop : props.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList())) {
            if (this.isSystemProp((String)prop.getKey()) || this.isEnvVariable((String)prop.getKey()) || !AnalysisContextReportPublisher.isSqProp((String)prop.getKey())) continue;
            AnalysisContextReportPublisher.dumpPropIfNotSensitive(fileWriter, (String)prop.getKey(), (String)prop.getValue());
        }
    }

    private static void dumpPropIfNotSensitive(BufferedWriter fileWriter, String prop, String value) throws IOException {
        fileWriter.append(String.format(KEY_VALUE_FORMAT, prop, AnalysisContextReportPublisher.isSensitiveProperty(prop) ? "******" : StringUtils.abbreviate((String)value, (int)1000))).append('\n');
    }

    private Map<String, String> collectModuleSpecificProps(DefaultInputModule module) {
        HashMap<String, String> moduleSpecificProps = new HashMap<String, String>();
        DefaultInputModule parent = this.hierarchy.parent(module);
        if (parent == null) {
            moduleSpecificProps.putAll(module.properties());
        } else {
            Map parentProps = parent.properties();
            for (Map.Entry entry : module.properties().entrySet()) {
                if (parentProps.containsKey(entry.getKey()) && ((String)parentProps.get(entry.getKey())).equals(entry.getValue())) continue;
                moduleSpecificProps.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return moduleSpecificProps;
    }

    private static boolean isSqProp(String propKey) {
        return propKey.startsWith(SONAR_PROP_PREFIX);
    }

    private boolean isSystemProp(String propKey) {
        return this.system.properties().containsKey(propKey) && !propKey.startsWith(SONAR_PROP_PREFIX);
    }

    private boolean isEnvVariable(String propKey) {
        return propKey.startsWith(ENV_PROP_PREFIX) && this.system.envVariables().containsKey(propKey.substring(ENV_PROP_PREFIX.length()));
    }

    private static boolean isSensitiveProperty(String key) {
        return key.equals("sonar.login") || key.contains(".password") || key.contains(".secured") || key.contains(".token");
    }
}

