/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.platform;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.platform.SonarQubeVersion;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;

public class DefaultServer
extends Server {
    private final Configuration settings;
    private final DefaultScannerWsClient client;
    private final SonarQubeVersion sonarQubeVersion;

    public DefaultServer(Configuration settings, DefaultScannerWsClient client, SonarQubeVersion sonarQubeVersion) {
        this.settings = settings;
        this.client = client;
        this.sonarQubeVersion = sonarQubeVersion;
    }

    public String getId() {
        return (String)this.settings.get("sonar.core.id").orElseThrow(() -> new IllegalStateException("Mandatory"));
    }

    public String getVersion() {
        return this.sonarQubeVersion.get().toString();
    }

    public Date getStartedAt() {
        String dateString = (String)this.settings.get("sonar.core.startTime").orElseThrow(() -> new IllegalStateException("Mandatory"));
        return DateUtils.parseDateTime((String)dateString);
    }

    public String getContextPath() {
        return null;
    }

    public String getPublicRootUrl() {
        String baseUrl = StringUtils.trimToEmpty((String)this.settings.get("sonar.core.serverBaseURL").orElse(""));
        if (baseUrl.isEmpty()) {
            baseUrl = this.client.baseUrl();
        }
        return StringUtils.removeEnd((String)baseUrl, (String)"/");
    }

    public boolean isSecured() {
        return false;
    }

    public String getPermanentServerId() {
        return this.getId();
    }
}

