/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;

@Immutable
public class IssuePattern {
    private final WildcardPattern filePattern;
    private final WildcardPattern rulePattern;

    public IssuePattern(String filePattern, String rulePattern) {
        this.filePattern = WildcardPattern.create((String)filePattern);
        this.rulePattern = WildcardPattern.create((String)rulePattern);
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    public boolean matchRule(RuleKey rule) {
        return this.rulePattern.match(rule.toString());
    }

    public boolean matchFile(@Nullable String filePath) {
        return filePath != null && this.filePattern.match(filePath);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filePattern", (Object)this.filePattern).add("rulePattern", (Object)this.rulePattern).toString();
    }
}

