/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.internal.DefaultActiveRules;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.scanner.issue.DefaultFilterableIssue;

public class IgnoreIssuesFilter
implements IssueFilter {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreIssuesFilter.class);
    private final DefaultActiveRules activeRules;
    private final AnalysisWarnings analysisWarnings;
    private final Map<InputComponent, List<WildcardPattern>> rulePatternByComponent = new HashMap<InputComponent, List<WildcardPattern>>();
    private final Set<RuleKey> warnedDeprecatedRuleKeys = new LinkedHashSet<RuleKey>();

    public IgnoreIssuesFilter(DefaultActiveRules activeRules, AnalysisWarnings analysisWarnings) {
        this.activeRules = activeRules;
        this.analysisWarnings = analysisWarnings;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
        if (IgnoreIssuesFilter.isIgnoreIssue(component, issue)) {
            return false;
        }
        if (this.hasRuleMatchFor(component, issue)) {
            return false;
        }
        return chain.accept(issue);
    }

    private static boolean isIgnoreIssue(InputComponent component, FilterableIssue issue) {
        if (component.isFile()) {
            DefaultInputFile inputFile = (DefaultInputFile)component;
            return inputFile.isIgnoreAllIssues() || inputFile.isIgnoreAllIssuesOnLine(issue.line());
        }
        return false;
    }

    public void addRuleExclusionPatternForComponent(DefaultInputFile inputFile, WildcardPattern rulePattern) {
        if ("*".equals(rulePattern.toString())) {
            inputFile.setIgnoreAllIssues(true);
        } else {
            this.rulePatternByComponent.computeIfAbsent((InputComponent)inputFile, x -> new LinkedList()).add(rulePattern);
        }
    }

    private boolean hasRuleMatchFor(InputComponent component, FilterableIssue issue) {
        for (WildcardPattern pattern : this.rulePatternByComponent.getOrDefault(component, Collections.emptyList())) {
            if (pattern.match(issue.ruleKey().toString())) {
                LOG.debug("Issue '{}' ignored by exclusion pattern '{}'", (Object)issue, (Object)pattern);
                return true;
            }
            RuleKey ruleKey = issue.ruleKey();
            if (!this.activeRules.matchesDeprecatedKeys(ruleKey, pattern)) continue;
            String msg = String.format("A multicriteria issue exclusion uses the rule key '%s' that has been changed. The pattern should be updated to '%s'", pattern, ruleKey);
            this.analysisWarnings.addUnique(msg);
            if (this.warnedDeprecatedRuleKeys.add(ruleKey)) {
                LOG.warn(msg);
            }
            LOG.debug("Issue '{}' ignored by exclusion pattern '{}' matching a deprecated rule key", (Object)issue, (Object)pattern);
            return true;
        }
        return false;
    }
}

