/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.Preconditions;
import org.sonar.scanner.deprecated.test.DefaultTestCase;
import org.sonar.scanner.deprecated.test.DefaultTestPlan;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.genericcoverage.GenericCoverageReportParser;
import org.sonar.scanner.genericcoverage.StaxParser;

public class GenericTestExecutionReportParser {
    private static final String ROOT_ELEMENT = "testExecutions";
    private static final String OLD_ROOT_ELEMENT = "unitTest";
    private static final Logger LOG = LoggerFactory.getLogger(GenericTestExecutionReportParser.class);
    private static final String NAME_ATTR = "name";
    private static final String DURATION_ATTR = "duration";
    public static final String ERROR = "error";
    public static final String FAILURE = "failure";
    public static final String SKIPPED = "skipped";
    private static final int MAX_STORED_UNKNOWN_FILE_PATHS = 5;
    private final TestPlanBuilder testPlanBuilder;
    private int numberOfUnknownFiles;
    private final List<String> firstUnknownFiles = new ArrayList<String>();
    private final Set<String> matchedFileKeys = new HashSet<String>();

    public GenericTestExecutionReportParser(TestPlanBuilder testPlanBuilder) {
        this.testPlanBuilder = testPlanBuilder;
    }

    public void parse(File reportFile, SensorContext context) {
        try (FileInputStream inputStream = new FileInputStream(reportFile);){
            this.parse(inputStream, context);
        }
        catch (Exception e) {
            throw MessageException.of((String)("Error during parsing of generic test execution report '" + reportFile + "'. Look at the SonarQube documentation to know the expected XML format."), (Throwable)e);
        }
    }

    private void parse(InputStream inputStream, SensorContext context) throws XMLStreamException {
        new StaxParser(rootCursor -> {
            rootCursor.advance();
            this.parseRootNode(rootCursor, context);
        }).parse(inputStream);
    }

    private void parseRootNode(SMHierarchicCursor rootCursor, SensorContext context) throws XMLStreamException {
        String version;
        String elementName = rootCursor.getLocalName();
        if (!OLD_ROOT_ELEMENT.equals(elementName) && !ROOT_ELEMENT.equals(elementName)) {
            throw new IllegalStateException("Unknown XML node, expected \"testExecutions\" but got \"" + elementName + "\" at line " + rootCursor.getCursorLocation().getLineNumber());
        }
        if (OLD_ROOT_ELEMENT.equals(elementName)) {
            LOG.warn("Using 'unitTest' as root element of the report is deprecated. Please change to 'testExecutions'.");
        }
        if (!"1".equals(version = rootCursor.getAttrValue("version"))) {
            throw new IllegalStateException("Unknown report version: " + version + ". This parser only handles version 1.");
        }
        this.parseFiles(rootCursor.childElementCursor(), context);
    }

    private void parseFiles(SMInputCursor fileCursor, SensorContext context) throws XMLStreamException {
        while (fileCursor.getNext() != null) {
            GenericCoverageReportParser.checkElementName(fileCursor, "file");
            String filePath = GenericCoverageReportParser.mandatoryAttribute(fileCursor, "path");
            InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(filePath));
            if (inputFile == null || inputFile.language() == null) {
                ++this.numberOfUnknownFiles;
                if (this.numberOfUnknownFiles <= 5) {
                    this.firstUnknownFiles.add(filePath);
                }
                if (inputFile == null) continue;
                LOG.debug("Skipping file '{}' in the generic test execution report because it doesn't have a known language", (Object)filePath);
                continue;
            }
            Preconditions.checkState((inputFile.type() != InputFile.Type.MAIN ? 1 : 0) != 0, (String)"Line %s of report refers to a file which is not configured as a test file: %s", (Object[])new Object[]{fileCursor.getCursorLocation().getLineNumber(), filePath});
            this.matchedFileKeys.add(inputFile.absolutePath());
            DefaultTestPlan testPlan = this.testPlanBuilder.getTestPlan(inputFile);
            SMInputCursor testCaseCursor = fileCursor.childElementCursor();
            while (testCaseCursor.getNext() != null) {
                GenericTestExecutionReportParser.parseTestCase(testCaseCursor, testPlan);
            }
        }
    }

    private static void parseTestCase(SMInputCursor cursor, DefaultTestPlan testPlan) throws XMLStreamException {
        GenericCoverageReportParser.checkElementName(cursor, "testCase");
        DefaultTestCase testCase = testPlan.addTestCase(GenericCoverageReportParser.mandatoryAttribute(cursor, NAME_ATTR));
        DefaultTestCase.Status status = DefaultTestCase.Status.OK;
        testCase.setDurationInMs(GenericCoverageReportParser.longValue(GenericCoverageReportParser.mandatoryAttribute(cursor, DURATION_ATTR), cursor, DURATION_ATTR, 0L));
        SMInputCursor child = cursor.descendantElementCursor();
        if (child.getNext() != null) {
            String elementName = child.getLocalName();
            if (SKIPPED.equals(elementName)) {
                status = DefaultTestCase.Status.SKIPPED;
            } else if (FAILURE.equals(elementName)) {
                status = DefaultTestCase.Status.FAILURE;
            } else if (ERROR.equals(elementName)) {
                status = DefaultTestCase.Status.ERROR;
            }
        }
        testCase.setStatus(status);
    }

    public int numberOfMatchedFiles() {
        return this.matchedFileKeys.size();
    }

    public int numberOfUnknownFiles() {
        return this.numberOfUnknownFiles;
    }

    public List<String> firstUnknownFiles() {
        return this.firstUnknownFiles;
    }
}

