/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Preconditions;
import org.sonar.core.sarif.Driver;
import org.sonar.core.sarif.Result;
import org.sonar.core.sarif.Run;
import org.sonar.core.sarif.Tool;
import org.sonar.scanner.externalissue.sarif.ResultMapper;
import org.sonar.scanner.externalissue.sarif.RulesSeverityDetector;

@ScannerSide
public class RunMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RunMapper.class);
    private final ResultMapper resultMapper;

    RunMapper(ResultMapper resultMapper) {
        this.resultMapper = resultMapper;
    }

    List<NewExternalIssue> mapRun(Run run) {
        if (run.getResults().isEmpty()) {
            return Collections.emptyList();
        }
        String driverName = RunMapper.getToolDriverName(run);
        Map<String, String> ruleSeveritiesByRuleId = RulesSeverityDetector.detectRulesSeverities(run, driverName);
        return run.getResults().stream().map(result -> this.toNewExternalIssue(driverName, (String)ruleSeveritiesByRuleId.get(result.getRuleId()), (Result)result)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static String getToolDriverName(Run run) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)RunMapper.hasToolDriverNameDefined(run), (String)"The run does not have a tool driver name defined.");
        return run.getTool().getDriver().getName();
    }

    private Optional<NewExternalIssue> toNewExternalIssue(String driverName, @Nullable String ruleSeverity, Result result) {
        try {
            return Optional.of(this.resultMapper.mapResult(driverName, ruleSeverity, result));
        }
        catch (Exception exception) {
            LOG.warn("Failed to import an issue raised by tool {}, error: {}", (Object)driverName, (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    private static boolean hasToolDriverNameDefined(Run run) {
        return Optional.ofNullable(run).map(Run::getTool).map(Tool::getDriver).map(Driver::getName).isPresent();
    }
}

