/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.rule.Severity;
import org.sonar.core.sarif.DefaultConfiguration;
import org.sonar.core.sarif.Extension;
import org.sonar.core.sarif.Result;
import org.sonar.core.sarif.Rule;
import org.sonar.core.sarif.Run;
import org.sonar.core.sarif.Tool;
import org.sonar.scanner.externalissue.sarif.ResultMapper;

public class RulesSeverityDetector {
    private static final Logger LOG = LoggerFactory.getLogger(RulesSeverityDetector.class);
    public static final String UNSUPPORTED_RULE_SEVERITIES_WARNING = "Unable to detect rules severity for issue detected by tool %s, falling back to default rule severity: %s";

    private RulesSeverityDetector() {
    }

    public static Map<String, String> detectRulesSeverities(Run run, String driverName) {
        Map<String, String> resultDefinedRuleSeverities = RulesSeverityDetector.getResultDefinedRuleSeverities(run);
        if (!resultDefinedRuleSeverities.isEmpty()) {
            return resultDefinedRuleSeverities;
        }
        Map<String, String> driverDefinedRuleSeverities = RulesSeverityDetector.getDriverDefinedRuleSeverities(run);
        if (!driverDefinedRuleSeverities.isEmpty()) {
            return driverDefinedRuleSeverities;
        }
        Map<String, String> extensionDefinedRuleSeverities = RulesSeverityDetector.getExtensionsDefinedRuleSeverities(run);
        if (!extensionDefinedRuleSeverities.isEmpty()) {
            return extensionDefinedRuleSeverities;
        }
        LOG.warn(RulesSeverityDetector.composeUnsupportedRuleSeveritiesDefinitionWarningMessage(driverName, ResultMapper.DEFAULT_SEVERITY));
        return Collections.emptyMap();
    }

    private static Map<String, String> getResultDefinedRuleSeverities(Run run) {
        Predicate<Result> hasResultDefinedLevel = result -> Optional.ofNullable(result).map(Result::getLevel).isPresent();
        return run.getResults().stream().filter(hasResultDefinedLevel).collect(Collectors.toMap(Result::getRuleId, Result::getLevel, (x, y) -> y));
    }

    private static Map<String, String> getDriverDefinedRuleSeverities(Run run) {
        return run.getTool().getDriver().getRules().stream().filter(RulesSeverityDetector::hasRuleDefinedLevel).collect(Collectors.toMap(Rule::getId, x -> x.getDefaultConfiguration().getLevel()));
    }

    private static Map<String, String> getExtensionsDefinedRuleSeverities(Run run) {
        return RulesSeverityDetector.getExtensions(run).stream().map(Extension::getRules).filter(Objects::nonNull).flatMap(Collection::stream).filter(RulesSeverityDetector::hasRuleDefinedLevel).collect(Collectors.toMap(Rule::getId, rule -> rule.getDefaultConfiguration().getLevel()));
    }

    private static Set<Extension> getExtensions(Run run) {
        return Optional.of(run).map(Run::getTool).map(Tool::getExtensions).orElse(Collections.emptySet());
    }

    private static boolean hasRuleDefinedLevel(@Nullable Rule rule) {
        return Optional.ofNullable(rule).map(Rule::getDefaultConfiguration).map(DefaultConfiguration::getLevel).isPresent();
    }

    private static String composeUnsupportedRuleSeveritiesDefinitionWarningMessage(String driverName, Severity defaultSeverity) {
        return String.format(UNSUPPORTED_RULE_SEVERITIES_WARNING, driverName, defaultSeverity);
    }
}

