/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.sarif.Location;
import org.sonar.core.sarif.Result;
import org.sonar.scanner.externalissue.sarif.LocationMapper;

@ScannerSide
public class ResultMapper {
    public static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    private static final Map<String, Severity> SEVERITY_MAPPING = ImmutableMap.builder().put((Object)"error", (Object)Severity.CRITICAL).put((Object)"warning", (Object)Severity.MAJOR).put((Object)"note", (Object)Severity.MINOR).put((Object)"none", (Object)Severity.INFO).build();
    private static final RuleType DEFAULT_TYPE = RuleType.VULNERABILITY;
    private final SensorContext sensorContext;
    private final LocationMapper locationMapper;

    ResultMapper(SensorContext sensorContext, LocationMapper locationMapper) {
        this.sensorContext = sensorContext;
        this.locationMapper = locationMapper;
    }

    NewExternalIssue mapResult(String driverName, @Nullable String ruleSeverity, Result result) {
        NewExternalIssue newExternalIssue = this.sensorContext.newExternalIssue();
        newExternalIssue.type(DEFAULT_TYPE);
        newExternalIssue.engineId(driverName);
        newExternalIssue.severity(ResultMapper.toSonarQubeSeverity(ruleSeverity));
        newExternalIssue.ruleId(Objects.requireNonNull(result.getRuleId(), "No ruleId found for issue thrown by driver " + driverName));
        this.mapLocations(result, newExternalIssue);
        return newExternalIssue;
    }

    private static Severity toSonarQubeSeverity(@Nullable String ruleSeverity) {
        return SEVERITY_MAPPING.getOrDefault(ruleSeverity, DEFAULT_SEVERITY);
    }

    private void mapLocations(Result result, NewExternalIssue newExternalIssue) {
        NewIssueLocation newIssueLocation = newExternalIssue.newLocation();
        Set locations = result.getLocations();
        if (locations == null || locations.isEmpty()) {
            newExternalIssue.at(this.locationMapper.fillIssueInProjectLocation(result, newIssueLocation));
        } else {
            Location firstLocation = (Location)locations.iterator().next();
            NewIssueLocation primaryLocation = this.fillFileOrProjectLocation(result, newIssueLocation, firstLocation);
            newExternalIssue.at(primaryLocation);
        }
    }

    private NewIssueLocation fillFileOrProjectLocation(Result result, NewIssueLocation newIssueLocation, Location firstLocation) {
        return Optional.ofNullable(this.locationMapper.fillIssueInFileLocation(result, newIssueLocation, firstLocation)).orElseGet(() -> this.locationMapper.fillIssueInProjectLocation(result, newIssueLocation));
    }
}

