/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.suffixtree.SuffixTreeCloneDetectionAlgorithm;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.index.PackedMemoryCloneIndex;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.cpd.DuplicationPredicates;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.util.ProgressReport;

public class CpdExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CpdExecutor.class);
    private static final int TIMEOUT = 300000;
    static final int MAX_CLONE_GROUP_PER_FILE = 100;
    static final int MAX_CLONE_PART_PER_GROUP = 100;
    private final SonarCpdBlockIndex index;
    private final ReportPublisher publisher;
    private final InputComponentStore componentStore;
    private final ProgressReport progressReport;
    private final CpdSettings settings;
    private final ExecutorService executorService;
    private int count = 0;
    private int total;

    @Inject
    public CpdExecutor(CpdSettings settings, SonarCpdBlockIndex index, ReportPublisher publisher, InputComponentStore inputComponentCache) {
        this(settings, index, publisher, inputComponentCache, Executors.newSingleThreadExecutor());
    }

    public CpdExecutor(CpdSettings settings, SonarCpdBlockIndex index, ReportPublisher publisher, InputComponentStore inputComponentCache, ExecutorService executorService) {
        this.settings = settings;
        this.index = index;
        this.publisher = publisher;
        this.componentStore = inputComponentCache;
        this.progressReport = new ProgressReport("CPD computation", TimeUnit.SECONDS.toMillis(10L));
        this.executorService = executorService;
    }

    public void execute() {
        this.execute(300000L);
    }

    void execute(long timeout) {
        ArrayList<FileBlocks> components = new ArrayList<FileBlocks>(this.index.noResources());
        Iterator<PackedMemoryCloneIndex.ResourceBlocks> it = this.index.iterator();
        while (it.hasNext()) {
            PackedMemoryCloneIndex.ResourceBlocks resourceBlocks = it.next();
            Optional<FileBlocks> fileBlocks = this.toFileBlocks(resourceBlocks.resourceId(), resourceBlocks.blocks());
            if (!fileBlocks.isPresent()) continue;
            components.add(fileBlocks.get());
        }
        int filesWithoutBlocks = this.index.noIndexedFiles() - this.index.noResources();
        if (filesWithoutBlocks > 0) {
            LOG.info("CPD Executor {} {} had no CPD blocks", (Object)filesWithoutBlocks, (Object)CpdExecutor.pluralize(filesWithoutBlocks));
        }
        this.total = components.size();
        this.progressReport.start(String.format("CPD Executor Calculating CPD for %d %s", this.total, CpdExecutor.pluralize(this.total)));
        try {
            for (FileBlocks fileBlocks : components) {
                this.runCpdAnalysis(this.executorService, fileBlocks.getInputFile(), fileBlocks.getBlocks(), timeout);
                ++this.count;
            }
            this.progressReport.stopAndLogTotalTime("CPD Executor CPD calculation finished");
        }
        catch (Exception e) {
            this.progressReport.stop("");
            throw e;
        }
        finally {
            this.executorService.shutdown();
        }
    }

    private static String pluralize(int files) {
        return files == 1 ? "file" : "files";
    }

    void runCpdAnalysis(ExecutorService executorService, DefaultInputFile inputFile, Collection<Block> fileBlocks, long timeout) {
        List filtered;
        List duplications;
        LOG.debug("Detection of duplications for {}", (Object)inputFile.absolutePath());
        this.progressReport.message(String.format("%d/%d - current file: %s", this.count, this.total, inputFile.absolutePath()));
        Future<List> futureResult = executorService.submit(() -> SuffixTreeCloneDetectionAlgorithm.detect((CloneIndex)this.index, (Collection)fileBlocks));
        try {
            duplications = futureResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout during detection of duplications for {}", (Object)inputFile.absolutePath());
            futureResult.cancel(true);
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail during detection of duplication for " + inputFile.absolutePath(), e);
        }
        if (!"java".equalsIgnoreCase(inputFile.language())) {
            int minTokens = this.settings.getMinimumTokens(inputFile.language());
            Predicate<CloneGroup> minimumTokensPredicate = DuplicationPredicates.numberOfUnitsNotLessThan(minTokens);
            filtered = duplications.stream().filter(minimumTokensPredicate).collect(Collectors.toList());
        } else {
            filtered = duplications;
        }
        this.saveDuplications((DefaultInputComponent)inputFile, filtered);
    }

    final void saveDuplications(final DefaultInputComponent component, List<CloneGroup> duplications) {
        if (duplications.size() > 100) {
            LOG.warn("Too many duplication groups on file {}. Keep only the first {} groups.", (Object)component, (Object)100);
        }
        Iterable reportDuplications = duplications.stream().limit(100L).map(new Function<CloneGroup, ScannerReport.Duplication>(){
            private final ScannerReport.Duplication.Builder dupBuilder = ScannerReport.Duplication.newBuilder();
            private final ScannerReport.Duplicate.Builder blockBuilder = ScannerReport.Duplicate.newBuilder();

            @Override
            public ScannerReport.Duplication apply(CloneGroup input) {
                return CpdExecutor.this.toReportDuplication((InputComponent)component, this.dupBuilder, this.blockBuilder, input);
            }
        })::iterator;
        this.publisher.getWriter().writeComponentDuplications(component.scannerId(), reportDuplications);
    }

    private Optional<FileBlocks> toFileBlocks(String componentKey, Collection<Block> fileBlocks) {
        DefaultInputFile component = (DefaultInputFile)this.componentStore.getByKey(componentKey);
        if (component == null) {
            LOG.error("Resource not found in component store: {}. Skipping CPD computation for it", (Object)componentKey);
            return Optional.empty();
        }
        return Optional.of(new FileBlocks(component, fileBlocks));
    }

    private ScannerReport.Duplication toReportDuplication(InputComponent component, ScannerReport.Duplication.Builder dupBuilder, ScannerReport.Duplicate.Builder blockBuilder, CloneGroup input) {
        dupBuilder.clear();
        ClonePart originBlock = input.getOriginPart();
        blockBuilder.clear();
        dupBuilder.setOriginPosition(ScannerReport.TextRange.newBuilder().setStartLine(originBlock.getStartLine()).setEndLine(originBlock.getEndLine()).build());
        int clonePartCount = 0;
        for (ClonePart duplicate : input.getCloneParts()) {
            if (duplicate.equals((Object)originBlock)) continue;
            if (++clonePartCount > 100) {
                LOG.warn("Too many duplication references on file " + component + " for block at line " + originBlock.getStartLine() + ". Keep only the first 100 references.");
                break;
            }
            blockBuilder.clear();
            String componentKey = duplicate.getResourceId();
            if (!component.key().equals(componentKey)) {
                DefaultInputComponent sameProjectComponent = (DefaultInputComponent)this.componentStore.getByKey(componentKey);
                blockBuilder.setOtherFileRef(sameProjectComponent.scannerId());
            }
            dupBuilder.addDuplicate(blockBuilder.setRange(ScannerReport.TextRange.newBuilder().setStartLine(duplicate.getStartLine()).setEndLine(duplicate.getEndLine()).build()).build());
        }
        return dupBuilder.build();
    }

    private static class FileBlocks {
        private final DefaultInputFile inputFile;
        private final Collection<Block> blocks;

        public FileBlocks(DefaultInputFile inputFile, Collection<Block> blocks) {
            this.inputFile = inputFile;
            this.blocks = blocks;
        }

        public DefaultInputFile getInputFile() {
            return this.inputFile;
        }

        public Collection<Block> getBlocks() {
            return this.blocks;
        }
    }
}

