/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class GithubActions
implements CiVendor {
    private static final String PROPERTY_COMMIT = "GITHUB_SHA";
    private final System2 system;

    public GithubActions(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return "Github Actions";
    }

    @Override
    public boolean isDetected() {
        return StringUtils.isNotBlank((String)this.system.envVariable("GITHUB_ACTION"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable(PROPERTY_COMMIT);
        if (StringUtils.isEmpty((String)revision)) {
            LoggerFactory.getLogger(this.getClass()).warn("Missing environment variable GITHUB_SHA");
        }
        return new CiConfigurationImpl(revision, this.getName());
    }
}

