/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class BitbucketPipelines
implements CiVendor {
    private final System2 system;

    public BitbucketPipelines(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return "Bitbucket Pipelines";
    }

    @Override
    public boolean isDetected() {
        String ci = this.system.envVariable("CI");
        String revision = this.system.envVariable("BITBUCKET_COMMIT");
        return "true".equals(ci) && StringUtils.isNotEmpty((String)revision);
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable("BITBUCKET_COMMIT");
        return new CiConfigurationImpl(revision, this.getName());
    }
}

