/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cache;

import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import org.sonar.api.scanner.fs.InputProject;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.FileUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.cache.AnalysisCacheLoader;
import org.sonar.scanner.protocol.internal.ScannerInternal;
import org.sonar.scanner.protocol.internal.SensorCacheData;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class DefaultAnalysisCacheLoader
implements AnalysisCacheLoader {
    private static final Logger LOG = Loggers.get(DefaultAnalysisCacheLoader.class);
    private static final String LOG_MSG = "Load analysis cache";
    static final String CONTENT_ENCODING = "Content-Encoding";
    static final String CONTENT_LENGTH = "Content-Length";
    static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String URL = "api/analysis_cache/get";
    private final DefaultScannerWsClient wsClient;
    private final InputProject project;
    private final BranchConfiguration branchConfiguration;

    public DefaultAnalysisCacheLoader(DefaultScannerWsClient wsClient, InputProject project, BranchConfiguration branchConfiguration) {
        this.project = project;
        this.branchConfiguration = branchConfiguration;
        this.wsClient = wsClient;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SensorCacheData> load() {
        String url = "api/analysis_cache/get?project=" + this.project.key();
        if (this.branchConfiguration.referenceBranchName() != null) {
            url = url + "&branch=" + this.branchConfiguration.referenceBranchName();
        }
        Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
        GetRequest request = (GetRequest)new GetRequest(url).setHeader(ACCEPT_ENCODING, "gzip");
        try (WsResponse response = this.wsClient.call((WsRequest)request);){
            Optional<SensorCacheData> optional;
            block19: {
                InputStream is = response.contentStream();
                try {
                    SensorCacheData cache;
                    Optional contentEncoding = response.header(CONTENT_ENCODING);
                    Optional<Integer> length = response.header(CONTENT_LENGTH).map(Integer::parseInt);
                    boolean hasGzipEncoding = contentEncoding.isPresent() && ((String)contentEncoding.get()).equals("gzip");
                    SensorCacheData sensorCacheData = cache = hasGzipEncoding ? this.decompress(is) : this.read(is);
                    if (length.isPresent()) {
                        profiler.stopInfo(LOG_MSG + String.format(" (%s)", FileUtils.humanReadableByteCountSI((long)length.get().intValue())));
                    } else {
                        profiler.stopInfo(LOG_MSG);
                    }
                    optional = Optional.of(cache);
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return optional;
        }
        catch (HttpException e) {
            if (e.code() == 404) {
                profiler.stopInfo("Load analysis cache (404)");
                return Optional.empty();
            }
            throw MessageException.of((String)("Failed to download analysis cache: " + DefaultScannerWsClient.createErrorMessage(e)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to download analysis cache", e);
        }
    }

    public SensorCacheData decompress(InputStream is) throws IOException {
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(is);){
            SensorCacheData sensorCacheData = this.read(gzipInputStream);
            return sensorCacheData;
        }
    }

    public SensorCacheData read(InputStream is) {
        Iterable it = () -> Protobuf.readStream((InputStream)is, (Parser)ScannerInternal.SensorCacheEntry.parser());
        return new SensorCacheData(StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList()));
    }
}

