/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cache;

import com.google.protobuf.ByteString;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonar.scanner.cache.AnalysisCacheLoader;
import org.sonar.scanner.cache.AnalysisCacheStorage;
import org.sonar.scanner.protocol.internal.SensorCacheData;

public class AnalysisCacheMemoryStorage
implements AnalysisCacheStorage {
    private final AnalysisCacheLoader loader;
    @Nullable
    private SensorCacheData cache;

    public AnalysisCacheMemoryStorage(AnalysisCacheLoader loader) {
        this.loader = loader;
    }

    @Override
    public InputStream get(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        return ((ByteString)this.cache.getEntries().get(key)).newInput();
    }

    @Override
    public boolean contains(String key) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.getEntries().containsKey(key);
    }

    public void load() {
        this.cache = this.loader.load().orElse(null);
    }
}

