/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.System2;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.scanner.bootstrap.DefaultScannerWsClient;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.WsConnector;
import org.springframework.context.annotation.Bean;

public class ScannerWsClientProvider {
    static final int CONNECT_TIMEOUT_MS = 5000;
    static final String READ_TIMEOUT_SEC_PROPERTY = "sonar.ws.timeout";
    public static final String TOKEN_PROPERTY = "sonar.token";
    private static final String TOKEN_ENV_VARIABLE = "SONAR_TOKEN";
    static final int DEFAULT_READ_TIMEOUT_SEC = 60;

    @Bean(value={"DefaultScannerWsClient"})
    public DefaultScannerWsClient provide(ScannerProperties scannerProps, EnvironmentInformation env, GlobalAnalysisMode globalMode, System2 system, AnalysisWarnings analysisWarnings) {
        String url = StringUtils.defaultIfBlank((String)scannerProps.property("sonar.host.url"), (String)"http://localhost:9000");
        HttpConnector.Builder connectorBuilder = HttpConnector.newBuilder();
        String timeoutSec = StringUtils.defaultIfBlank((String)scannerProps.property(READ_TIMEOUT_SEC_PROPERTY), (String)String.valueOf(60));
        String envVarToken = StringUtils.defaultIfBlank((String)system.envVariable(TOKEN_ENV_VARIABLE), null);
        String token = StringUtils.defaultIfBlank((String)scannerProps.property(TOKEN_PROPERTY), (String)envVarToken);
        String login = StringUtils.defaultIfBlank((String)scannerProps.property("sonar.login"), (String)token);
        connectorBuilder.readTimeoutMilliseconds(Integer.parseInt(timeoutSec) * 1000).connectTimeoutMilliseconds(5000).userAgent(env.toString()).url(url).credentials(login, scannerProps.property("sonar.password"));
        String proxyUser = System.getProperty("http.proxyUser", "");
        if (!proxyUser.isEmpty()) {
            connectorBuilder.proxyCredentials(proxyUser, System.getProperty("http.proxyPassword"));
        }
        return new DefaultScannerWsClient(WsClientFactories.getDefault().newClient((WsConnector)connectorBuilder.build()), login != null, globalMode, analysisWarnings);
    }
}

