/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.function.Predicate;
import org.sonar.api.utils.ZipUtils;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.PluginFiles;

public class ScannerPluginJarExploder
extends PluginJarExploder {
    private final PluginFiles pluginFiles;

    public ScannerPluginJarExploder(PluginFiles pluginFiles) {
        this.pluginFiles = pluginFiles;
    }

    public ExplodedPlugin explode(PluginInfo info) {
        try {
            File dir = this.unzipFile(info.getNonNullJarFile());
            return this.explodeFromUnzippedDir(info, info.getNonNullJarFile(), dir);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to open plugin [%s]: %s", info.getKey(), info.getNonNullJarFile().getAbsolutePath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipFile(File cachedFile) throws IOException {
        String filename = cachedFile.getName();
        File destDir = new File(cachedFile.getParentFile(), filename + "_unzip");
        File lockFile = new File(cachedFile.getParentFile(), filename + "_unzip.lock");
        if (!destDir.exists()) {
            try (FileOutputStream out = new FileOutputStream(lockFile);){
                FileLock lock = ScannerPluginJarExploder.createLockWithRetries(out.getChannel());
                try {
                    if (!destDir.exists()) {
                        File tempDir = this.pluginFiles.createTempDir();
                        ZipUtils.unzip((File)cachedFile, (File)tempDir, (Predicate)this.newLibFilter());
                        org.apache.commons.io.FileUtils.moveDirectory((File)tempDir, (File)destDir);
                    }
                }
                finally {
                    lock.release();
                }
            }
            finally {
                FileUtils.deleteQuietly((File)lockFile);
            }
        }
        return destDir;
    }

    private static FileLock createLockWithRetries(FileChannel channel) throws IOException {
        int tryCount = 0;
        while (tryCount++ < 10) {
            try {
                return channel.lock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                try {
                    Thread.sleep(200L * (long)tryCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new IOException("Unable to get lock after " + tryCount + " tries");
    }
}

