/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.repository.settings.GlobalSettingsLoader;
import org.springframework.context.annotation.Bean;

public class GlobalServerSettingsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalServerSettingsProvider.class);

    @Bean(value={"GlobalServerSettings"})
    public GlobalServerSettings provide(GlobalSettingsLoader loader) {
        Map<String, String> serverSideSettings = loader.loadGlobalSettings();
        Optional.ofNullable(serverSideSettings.get("sonar.core.id")).ifPresent(v -> LOG.info("Server id: {}", v));
        return new GlobalServerSettings(serverSideSettings);
    }
}

