/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner;

import java.time.Clock;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.MessageException;

public class ProjectInfo
implements Startable {
    private final Clock clock;
    private final Configuration settings;
    private Date analysisDate;
    private String projectVersion;
    private String buildString;

    public ProjectInfo(Configuration settings, Clock clock) {
        this.settings = settings;
        this.clock = clock;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    public Optional<String> getProjectVersion() {
        return Optional.ofNullable(this.projectVersion);
    }

    public Optional<String> getBuildString() {
        return Optional.ofNullable(this.buildString);
    }

    private Date loadAnalysisDate() {
        Optional value = this.settings.get("sonar.projectDate");
        if (value.isEmpty()) {
            return Date.from(this.clock.instant());
        }
        try {
            return DateUtils.parseDateTime((String)((String)value.get()));
        }
        catch (RuntimeException runtimeException) {
            try {
                return DateUtils.parseDate((String)((String)value.get()));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Illegal value for 'sonar.projectDate'", e);
            }
        }
    }

    public void start() {
        this.analysisDate = this.loadAnalysisDate();
        this.projectVersion = this.settings.get("sonar.projectVersion").map(StringUtils::trimToNull).filter(ProjectInfo.validateLengthLimit("project version")).orElse(null);
        this.buildString = this.settings.get("sonar.buildString").map(StringUtils::trimToNull).filter(ProjectInfo.validateLengthLimit("buildString")).orElse(null);
    }

    private static Predicate<String> validateLengthLimit(String label) {
        return value -> {
            if (value.length() > 100) {
                throw MessageException.of((String)String.format("\"%s\" is not a valid %s. The maximum length is 100 characters.", value, label));
            }
            return true;
        };
    }

    public void stop() {
    }
}

