/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.sonar.api.internal.google.common.base.Preconditions;

public class Paging {
    private final int pageSize;
    private final int pageIndex;
    private final int total;

    private Paging(int pageSize, int pageIndex, int total) {
        Preconditions.checkArgument(pageSize >= 1, "Page size must be strictly positive. Got %s", pageSize);
        Preconditions.checkArgument(pageIndex >= 1, "Page index must be strictly positive. Got %s", pageIndex);
        Preconditions.checkArgument(total >= 0, "Total items must be positive. Got %s", total);
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.total = total;
    }

    @Deprecated
    public static Paging create(int pageSize, int pageIndex, int totalItems) {
        return new Paging(pageSize, pageIndex, totalItems);
    }

    public static Builder forPageIndex(int pageIndex) {
        return new Builder(pageIndex);
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int total() {
        return this.total;
    }

    public int offset() {
        return (this.pageIndex - 1) * this.pageSize;
    }

    public static int offset(int pageIndex, int pageSize) {
        return (pageIndex - 1) * pageSize;
    }

    public int pages() {
        int p = this.total / this.pageSize;
        if (this.total % this.pageSize > 0) {
            ++p;
        }
        return p;
    }

    public boolean hasNextPage() {
        return this.pageIndex() < this.pages();
    }

    public static class Builder {
        private int pageSize;
        private int pageIndex;

        private Builder(int pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Builder withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Paging andTotal(int total) {
            return new Paging(this.pageSize, this.pageIndex, total);
        }
    }
}

