/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.utils.PathUtils;

public class DefaultInputDir
extends DefaultInputComponent
implements InputDir {
    private final String relativePath;
    private final String moduleKey;
    private Path moduleBaseDir;

    public DefaultInputDir(String moduleKey, String relativePath) {
        super(-1);
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize((String)relativePath);
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String absolutePath() {
        return PathUtils.sanitize((String)this.path().toString());
    }

    public File file() {
        return this.path().toFile();
    }

    public Path path() {
        if (this.moduleBaseDir == null) {
            throw new IllegalStateException("Can not return the java.nio.file.Path because module baseDir is not set (see method setModuleBaseDir(java.io.File))");
        }
        return this.moduleBaseDir.resolve(this.relativePath);
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public String key() {
        StringBuilder sb = new StringBuilder().append(this.moduleKey).append(":");
        if (StringUtils.isEmpty((String)this.relativePath)) {
            sb.append("/");
        } else {
            sb.append(this.relativePath);
        }
        return sb.toString();
    }

    public DefaultInputDir setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir.normalize();
        return this;
    }

    public boolean isFile() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInputDir that = (DefaultInputDir)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    @Override
    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    @Override
    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", basedir=" + this.moduleBaseDir + "]";
    }

    public URI uri() {
        return this.path().toUri();
    }
}

