/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import java.util.Collection;
import java.util.Iterator;
import org.sonar.api.internal.google.common.collect.ArrayListMultimap;
import org.sonar.api.internal.google.common.collect.Multimap;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.PackedMemoryCloneIndex;

public class MemoryCloneIndex
implements CloneIndex {
    private Multimap<String, Block> byResource = ArrayListMultimap.create();
    private Multimap<ByteArray, Block> byHash = ArrayListMultimap.create();

    @Override
    public Collection<Block> getByResourceId(String resourceId) {
        return this.byResource.get(resourceId);
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        return this.byHash.get(sequenceHash);
    }

    @Override
    public void insert(Block block) {
        this.byResource.put(block.getResourceId(), block);
        this.byHash.put(block.getBlockHash(), block);
    }

    @Override
    public Iterator<PackedMemoryCloneIndex.ResourceBlocks> iterator() {
        throw new UnsupportedOperationException();
    }
}

