/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.core.issue.tracking.LineHashSequence;

public class BlockHashSequence {
    public static final int DEFAULT_HALF_BLOCK_SIZE = 5;
    private final int[] blockHashes;

    BlockHashSequence(LineHashSequence lineHashSequence, int halfBlockSize) {
        this.blockHashes = new int[lineHashSequence.length()];
        BlockHashFactory blockHashFactory = new BlockHashFactory(lineHashSequence.getHashes(), halfBlockSize);
        for (int line = 1; line <= lineHashSequence.length(); ++line) {
            this.blockHashes[line - 1] = blockHashFactory.getHash();
            if (line - halfBlockSize > 0) {
                blockHashFactory.remove(lineHashSequence.getHashForLine(line - halfBlockSize).hashCode());
            }
            if (line + 1 + halfBlockSize <= lineHashSequence.length()) {
                blockHashFactory.add(lineHashSequence.getHashForLine(line + 1 + halfBlockSize).hashCode());
                continue;
            }
            blockHashFactory.add(0);
        }
    }

    public static BlockHashSequence create(LineHashSequence lineHashSequence) {
        return new BlockHashSequence(lineHashSequence, 5);
    }

    public int getBlockHashForLine(int line) {
        return this.blockHashes[line - 1];
    }

    public boolean hasLine(@Nullable Integer line) {
        return line != null && line > 0 && line <= this.blockHashes.length;
    }

    private static class BlockHashFactory {
        private static final int PRIME_BASE = 31;
        private final int power;
        private int hash = 0;

        public BlockHashFactory(List<String> hashes, int halfBlockSize) {
            int i;
            int pow = 1;
            for (i = 0; i < halfBlockSize * 2; ++i) {
                pow *= 31;
            }
            this.power = pow;
            for (i = 1; i <= Math.min(hashes.size(), halfBlockSize + 1); ++i) {
                this.add(hashes.get(i - 1).hashCode());
            }
        }

        public void add(int value) {
            this.hash = this.hash * 31 + value;
        }

        public void remove(int value) {
            this.hash -= this.power * value;
        }

        public int getHash() {
            return this.hash;
        }
    }
}

