/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.issue.ActionPlan;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.api.user.User;
import org.sonar.api.utils.Duration;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.IssueChangeContext;

@ServerSide
public class IssueUpdater {
    public static final String UNUSED = "";
    public static final String SEVERITY = "severity";
    public static final String ASSIGNEE = "assignee";
    public static final String RESOLUTION = "resolution";
    public static final String STATUS = "status";
    public static final String AUTHOR = "author";
    public static final String ACTION_PLAN = "actionPlan";
    public static final String TECHNICAL_DEBT = "technicalDebt";
    public static final String TAGS = "tags";
    private static final Joiner CHANGELOG_TAG_JOINER = Joiner.on((String)" ").skipNulls();

    public boolean setSeverity(DefaultIssue issue, String severity, IssueChangeContext context) {
        if (issue.manualSeverity()) {
            throw new IllegalStateException("Severity can't be changed");
        }
        if (!Objects.equal((Object)severity, (Object)issue.severity())) {
            issue.setFieldChange(context, SEVERITY, (Serializable)((Object)issue.severity()), (Serializable)((Object)severity));
            issue.setSeverity(severity);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastSeverity(DefaultIssue issue, @Nullable String previousSeverity, IssueChangeContext context) {
        String currentSeverity = issue.severity();
        issue.setSeverity(previousSeverity);
        return this.setSeverity(issue, currentSeverity, context);
    }

    public boolean setManualSeverity(DefaultIssue issue, String severity, IssueChangeContext context) {
        if (!issue.manualSeverity() || !Objects.equal((Object)severity, (Object)issue.severity())) {
            issue.setFieldChange(context, SEVERITY, (Serializable)((Object)issue.severity()), (Serializable)((Object)severity));
            issue.setSeverity(severity);
            issue.setManualSeverity(true);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean assign(DefaultIssue issue, @Nullable User user, IssueChangeContext context) {
        String sanitizedAssignee = null;
        if (user != null) {
            sanitizedAssignee = StringUtils.defaultIfBlank(user.login(), null);
        }
        if (!Objects.equal(sanitizedAssignee, (Object)issue.assignee())) {
            String newAssigneeName = user != null ? user.name() : null;
            issue.setFieldChange(context, ASSIGNEE, (Serializable)((Object)UNUSED), (Serializable)((Object)newAssigneeName));
            issue.setAssignee(sanitizedAssignee);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setNewAssignee(DefaultIssue issue, @Nullable String newAssignee, IssueChangeContext context) {
        if (newAssignee == null) {
            return false;
        }
        Preconditions.checkState((issue.assignee() == null ? 1 : 0) != 0, (Object)"It's not possible to update the assignee with this method, please use assign()");
        issue.setFieldChange(context, ASSIGNEE, (Serializable)((Object)UNUSED), (Serializable)((Object)newAssignee));
        issue.setAssignee(newAssignee);
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
        issue.setSendNotifications(true);
        return true;
    }

    public boolean setLine(DefaultIssue issue, @Nullable Integer line) {
        if (!Objects.equal((Object)line, (Object)issue.line())) {
            issue.setLine(line);
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastLine(DefaultIssue issue, @Nullable Integer previousLine) {
        Integer currentLine = issue.line();
        issue.setLine(previousLine);
        return this.setLine(issue, currentLine);
    }

    public boolean setLocations(DefaultIssue issue, @Nullable Object locations) {
        if (!Objects.equal((Object)locations, issue.getLocations())) {
            issue.setLocations(locations);
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastLocations(DefaultIssue issue, @Nullable Object previousLocations) {
        Object currentLocations = issue.getLocations();
        issue.setLocations(previousLocations);
        return this.setLocations(issue, currentLocations);
    }

    public boolean setResolution(DefaultIssue issue, @Nullable String resolution, IssueChangeContext context) {
        if (!Objects.equal((Object)resolution, (Object)issue.resolution())) {
            issue.setFieldChange(context, RESOLUTION, (Serializable)((Object)issue.resolution()), (Serializable)((Object)resolution));
            issue.setResolution(resolution);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setStatus(DefaultIssue issue, String status, IssueChangeContext context) {
        if (!Objects.equal((Object)status, (Object)issue.status())) {
            issue.setFieldChange(context, STATUS, (Serializable)((Object)issue.status()), (Serializable)((Object)status));
            issue.setStatus(status);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setAuthorLogin(DefaultIssue issue, @Nullable String authorLogin, IssueChangeContext context) {
        if (!Objects.equal((Object)authorLogin, (Object)issue.authorLogin())) {
            issue.setFieldChange(context, AUTHOR, (Serializable)((Object)issue.authorLogin()), (Serializable)((Object)authorLogin));
            issue.setAuthorLogin(authorLogin);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setNewAuthor(DefaultIssue issue, @Nullable String newAuthorLogin, IssueChangeContext context) {
        if (Strings.isNullOrEmpty((String)newAuthorLogin)) {
            return false;
        }
        Preconditions.checkState((issue.authorLogin() == null ? 1 : 0) != 0, (Object)"It's not possible to update the author with this method, please use setAuthorLogin()");
        issue.setFieldChange(context, AUTHOR, null, (Serializable)((Object)newAuthorLogin));
        issue.setAuthorLogin(newAuthorLogin);
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
        return true;
    }

    public boolean setMessage(DefaultIssue issue, @Nullable String s, IssueChangeContext context) {
        if (!Objects.equal((Object)s, (Object)issue.message())) {
            issue.setMessage(s);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastMessage(DefaultIssue issue, @Nullable String previousMessage, IssueChangeContext context) {
        String currentMessage = issue.message();
        issue.setMessage(previousMessage);
        return this.setMessage(issue, currentMessage, context);
    }

    public void addComment(DefaultIssue issue, String text, IssueChangeContext context) {
        issue.addComment(DefaultIssueComment.create(issue.key(), context.login(), text));
        issue.setUpdateDate(context.date());
        issue.setChanged(true);
    }

    public void setCloseDate(DefaultIssue issue, @Nullable Date d, IssueChangeContext context) {
        Date dateWithoutMilliseconds;
        Date date = dateWithoutMilliseconds = d == null ? null : DateUtils.truncate(d, 13);
        if (!Objects.equal((Object)dateWithoutMilliseconds, (Object)issue.closeDate())) {
            issue.setCloseDate(d);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
        }
    }

    public boolean setEffortToFix(DefaultIssue issue, @Nullable Double d, IssueChangeContext context) {
        if (!Objects.equal((Object)d, (Object)issue.effortToFix())) {
            issue.setEffortToFix(d);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastEffortToFix(DefaultIssue issue, @Nullable Double previousEffort, IssueChangeContext context) {
        Double currentEffort = issue.effortToFix();
        issue.setEffortToFix(previousEffort);
        return this.setEffortToFix(issue, currentEffort, context);
    }

    public boolean setTechnicalDebt(DefaultIssue issue, @Nullable Duration value, IssueChangeContext context) {
        Duration oldValue = issue.debt();
        if (!Objects.equal((Object)value, (Object)oldValue)) {
            issue.setDebt(value != null ? value : null);
            issue.setFieldChange(context, TECHNICAL_DEBT, oldValue != null ? Long.valueOf(oldValue.toMinutes()) : null, value != null ? Long.valueOf(value.toMinutes()) : null);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastTechnicalDebt(DefaultIssue issue, @Nullable Duration previousTechnicalDebt, IssueChangeContext context) {
        Duration currentTechnicalDebt = issue.debt();
        issue.setDebt(previousTechnicalDebt);
        return this.setTechnicalDebt(issue, currentTechnicalDebt, context);
    }

    public boolean setAttribute(DefaultIssue issue, String key, @Nullable String value, IssueChangeContext context) {
        String oldValue = issue.attribute(key);
        if (!Objects.equal((Object)oldValue, (Object)value)) {
            issue.setFieldChange(context, key, (Serializable)((Object)oldValue), (Serializable)((Object)value));
            issue.setAttribute(key, value);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean plan(DefaultIssue issue, @Nullable ActionPlan actionPlan, IssueChangeContext context) {
        String sanitizedActionPlanKey = null;
        if (actionPlan != null) {
            sanitizedActionPlanKey = StringUtils.defaultIfBlank(actionPlan.key(), null);
        }
        if (!Objects.equal(sanitizedActionPlanKey, (Object)issue.actionPlanKey())) {
            String newActionPlanName = actionPlan != null ? actionPlan.name() : null;
            issue.setFieldChange(context, ACTION_PLAN, (Serializable)((Object)UNUSED), (Serializable)((Object)newActionPlanName));
            issue.setActionPlanKey(sanitizedActionPlanKey);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }

    public boolean setProject(DefaultIssue issue, String projectKey, IssueChangeContext context) {
        if (!Objects.equal((Object)projectKey, (Object)issue.projectKey())) {
            issue.setProjectKey(projectKey);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean setPastProject(DefaultIssue issue, String previousKey, IssueChangeContext context) {
        String currentProjectKey = issue.projectKey();
        issue.setProjectKey(previousKey);
        return this.setProject(issue, currentProjectKey, context);
    }

    public boolean setTags(DefaultIssue issue, Collection<String> tags, IssueChangeContext context) {
        HashSet newTags = Sets.newHashSet((Iterable)Collections2.transform((Collection)Collections2.filter(tags, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String tag) {
                return tag != null && !tag.isEmpty();
            }
        }), (Function)new Function<String, String>(){

            public String apply(String tag) {
                String lowerCaseTag = tag.toLowerCase();
                RuleTagFormat.validate(lowerCaseTag);
                return lowerCaseTag;
            }
        }));
        HashSet oldTags = Sets.newHashSet((Iterable)issue.tags());
        if (!oldTags.equals(newTags)) {
            issue.setFieldChange(context, TAGS, (Serializable)((Object)(oldTags.isEmpty() ? null : CHANGELOG_TAG_JOINER.join((Iterable)oldTags))), (Serializable)((Object)(newTags.isEmpty() ? null : CHANGELOG_TAG_JOINER.join((Iterable)newTags))));
            issue.setTags(newTags);
            issue.setUpdateDate(context.date());
            issue.setChanged(true);
            issue.setSendNotifications(true);
            return true;
        }
        return false;
    }
}

