/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.hash;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class SourceLinesHashesComputer {
    private final MessageDigest md5Digest = DigestUtils.getMd5Digest();
    private final List<String> lineHashes;

    public SourceLinesHashesComputer() {
        this.lineHashes = new ArrayList<String>();
    }

    public SourceLinesHashesComputer(int expectedLineCount) {
        this.lineHashes = new ArrayList<String>(expectedLineCount);
    }

    public void addLine(String line) {
        Objects.requireNonNull(line, "line can not be null");
        this.lineHashes.add(this.computeHash(line));
    }

    public List<String> getLineHashes() {
        return ImmutableList.copyOf(this.lineHashes);
    }

    private String computeHash(String line) {
        String reducedLine = StringUtils.replaceChars(line, "\t ", "");
        if (reducedLine.isEmpty()) {
            return "";
        }
        return Hex.encodeHexString(this.md5Digest.digest(reducedLine.getBytes(StandardCharsets.UTF_8)));
    }
}

