/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringStyle;
import org.sonar.api.internal.google.common.base.Preconditions;

public abstract class DefaultStorable {
    protected final transient SensorStorage storage;
    private transient boolean saved = false;

    public DefaultStorable() {
        this.storage = null;
    }

    public DefaultStorable(@Nullable SensorStorage storage) {
        this.storage = storage;
    }

    public final void save() {
        Preconditions.checkNotNull(this.storage, "No persister on this object");
        Preconditions.checkState(!this.saved, "This object was already saved");
        this.doSave();
        this.saved = true;
    }

    protected abstract void doSave();

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected void validateLineArgument(InputFile inputFile, int line, String label) {
        Preconditions.checkArgument(line > 0 && line <= inputFile.lines(), "Invalid " + label + ": " + line + ". File " + inputFile + " has " + inputFile.lines() + " lines.");
    }
}

