/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.TempFolder;
import org.sonar.classloader.ClassloaderBuilder;
import org.sonar.classloader.Mask;
import org.sonar.core.platform.PluginClassLoaderDef;

@BatchSide
@ServerSide
public class PluginClassloaderFactory {
    private static final String API_CLASSLOADER_KEY = "_api_";
    private final TempFolder temp;
    private URL compatibilityModeJar;

    public PluginClassloaderFactory(TempFolder temp) {
        this.temp = temp;
    }

    public Map<PluginClassLoaderDef, ClassLoader> create(Collection<PluginClassLoaderDef> defs) {
        ClassLoader baseClassLoader = this.baseClassLoader();
        ClassloaderBuilder builder = new ClassloaderBuilder();
        builder.newClassloader(API_CLASSLOADER_KEY, baseClassLoader);
        builder.setMask(API_CLASSLOADER_KEY, PluginClassloaderFactory.apiMask());
        for (PluginClassLoaderDef def : defs) {
            builder.newClassloader(def.getBasePluginKey());
            if (def.isPrivileged()) {
                builder.setParent(def.getBasePluginKey(), baseClassLoader, new Mask());
            } else {
                builder.setParent(def.getBasePluginKey(), API_CLASSLOADER_KEY, new Mask());
            }
            builder.setLoadingOrder(def.getBasePluginKey(), def.isSelfFirstStrategy() ? ClassloaderBuilder.LoadingOrder.SELF_FIRST : ClassloaderBuilder.LoadingOrder.PARENT_FIRST);
            for (File jar : def.getFiles()) {
                builder.addURL(def.getBasePluginKey(), PluginClassloaderFactory.fileToUrl(jar));
            }
            if (def.isCompatibilityMode()) {
                builder.addURL(def.getBasePluginKey(), this.extractCompatibilityModeJar());
            }
            this.exportResources(def, builder, defs);
        }
        return this.build(defs, builder);
    }

    private void exportResources(PluginClassLoaderDef def, ClassloaderBuilder builder, Collection<PluginClassLoaderDef> allPlugins) {
        builder.setExportMask(def.getBasePluginKey(), def.getExportMask());
        for (PluginClassLoaderDef other : allPlugins) {
            if (other.getBasePluginKey().equals(def.getBasePluginKey())) continue;
            builder.addSibling(def.getBasePluginKey(), other.getBasePluginKey(), new Mask());
        }
    }

    private Map<PluginClassLoaderDef, ClassLoader> build(Collection<PluginClassLoaderDef> defs, ClassloaderBuilder builder) {
        HashMap<PluginClassLoaderDef, ClassLoader> result = new HashMap<PluginClassLoaderDef, ClassLoader>();
        Map<String, ClassLoader> classloadersByBasePluginKey = builder.build();
        for (PluginClassLoaderDef def : defs) {
            ClassLoader classloader = classloadersByBasePluginKey.get(def.getBasePluginKey());
            if (classloader == null) {
                throw new IllegalStateException(String.format("Fail to create classloader for plugin [%s]", def.getBasePluginKey()));
            }
            result.put(def, classloader);
        }
        return result;
    }

    ClassLoader baseClassLoader() {
        return this.getClass().getClassLoader();
    }

    private URL extractCompatibilityModeJar() {
        if (this.compatibilityModeJar == null) {
            File jar = this.temp.newFile("sonar-plugin-api-deps", "jar");
            try {
                FileUtils.copyURLToFile(this.getClass().getResource("/sonar-plugin-api-deps.jar"), jar);
                this.compatibilityModeJar = jar.toURI().toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not extract sonar-plugin-api-deps.jar to " + jar.getAbsolutePath(), e);
            }
        }
        return this.compatibilityModeJar;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Mask apiMask() {
        return new Mask().addInclusion("org/sonar/api/").addInclusion("org/sonar/channel/").addInclusion("org/sonar/check/").addInclusion("org/sonar/colorizer/").addInclusion("org/sonar/duplications/").addInclusion("org/sonar/graph/").addInclusion("org/sonar/plugins/emailnotifications/api/").addInclusion("net/sourceforge/pmd/").addInclusion("org/apache/maven/").addInclusion("org/codehaus/stax2/").addInclusion("org/codehaus/staxmate/").addInclusion("com/ctc/wstx/").addInclusion("org/slf4j/").addInclusion("javax/servlet/").addInclusion("org/apache/commons/logging/").addInclusion("org/apache/log4j/").addInclusion("ch/qos/logback/").addInclusion("org/sonar/server/platform/").addInclusion("org/sonar/core/persistence/").addInclusion("org/sonar/core/properties/").addInclusion("org/sonar/server/views/").addExclusion("org/sonar/api/internal/");
    }
}

