/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.component;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

public final class ComponentKeys {
    public static final int COMPONENT_KEY_SIZE = 400;
    private static final String VALID_MODULE_KEY_REGEXP = "[\\p{Alnum}\\-_.:]*[\\p{Alpha}\\-_.:]+[\\p{Alnum}\\-_.:]*";
    private static final String VALID_MODULE_KEY_ISSUES_MODE_REGEXP = "[\\p{Alnum}\\-_.:/]*[\\p{Alpha}\\-_.:/]+[\\p{Alnum}\\-_.:/]*";
    private static final String VALID_BRANCH_REGEXP = "[\\p{Alnum}\\-_./]*";
    private static final String KEY_WITH_BRANCH_FORMAT = "%s:%s";

    private ComponentKeys() {
    }

    public static String createEffectiveKey(Project project, Resource resource) {
        String key = resource.getKey();
        if (!StringUtils.equals("PRJ", resource.getScope())) {
            key = new StringBuilder(400).append(project.getKey()).append(':').append(resource.getKey()).toString();
        }
        return key;
    }

    public static String createEffectiveKey(String moduleKey, InputPath inputPath) {
        return ComponentKeys.createEffectiveKey(moduleKey, inputPath.relativePath());
    }

    public static String createEffectiveKey(String moduleKey, @Nullable String path) {
        StringBuilder sb = new StringBuilder(400);
        sb.append(moduleKey);
        if (path != null) {
            sb.append(':').append(path);
        }
        return sb.toString();
    }

    public static boolean isValidModuleKey(String keyCandidate) {
        return keyCandidate.matches(VALID_MODULE_KEY_REGEXP);
    }

    public static boolean isValidModuleKeyIssuesMode(String keyCandidate) {
        return keyCandidate.matches(VALID_MODULE_KEY_ISSUES_MODE_REGEXP);
    }

    public static boolean isValidBranch(String branchCandidate) {
        return branchCandidate.matches(VALID_BRANCH_REGEXP);
    }

    public static String createKey(String keyWithoutBranch, @Nullable String branch) {
        if (StringUtils.isNotBlank(branch)) {
            return String.format(KEY_WITH_BRANCH_FORMAT, keyWithoutBranch, branch);
        }
        return keyWithoutBranch;
    }

    public static String createKey(String moduleKey, @Nullable String path, @Nullable String branch) {
        String key = ComponentKeys.createKey(moduleKey, branch);
        return ComponentKeys.createEffectiveKey(key, path);
    }
}

