/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.sonar.api.internal.apachecommons.lang.ArrayUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.resources.Resource;

public final class Scopes {
    public static final String PROJECT = "PRJ";
    public static final String DIRECTORY = "DIR";
    public static final String FILE = "FIL";
    @Deprecated
    public static final String PROGRAM_UNIT = "PGU";
    @Deprecated
    public static final String BLOCK_UNIT = "BLU";
    public static final String[] SORTED_SCOPES = new String[]{"PRJ", "DIR", "FIL", "PGU", "BLU"};

    private Scopes() {
    }

    public static boolean isProject(Resource resource) {
        return StringUtils.equals(PROJECT, resource.getScope());
    }

    public static boolean isDirectory(Resource resource) {
        return StringUtils.equals(DIRECTORY, resource.getScope());
    }

    public static boolean isFile(Resource resource) {
        return StringUtils.equals(FILE, resource.getScope());
    }

    @Deprecated
    public static boolean isProgramUnit(Resource resource) {
        return StringUtils.equals(PROGRAM_UNIT, resource.getScope());
    }

    @Deprecated
    public static boolean isBlockUnit(Resource resource) {
        return StringUtils.equals(BLOCK_UNIT, resource.getScope());
    }

    public static boolean isHigherThan(Resource resource, String than) {
        return Scopes.isHigherThan(resource.getScope(), than);
    }

    public static boolean isHigherThan(String scope, String than) {
        int thanIndex;
        int index = ArrayUtils.indexOf(SORTED_SCOPES, scope);
        return index < (thanIndex = ArrayUtils.indexOf(SORTED_SCOPES, than));
    }

    public static boolean isHigherThanOrEquals(Resource resource, String than) {
        return Scopes.isHigherThanOrEquals(resource.getScope(), than);
    }

    public static boolean isHigherThanOrEquals(String scope, String than) {
        int thanIndex;
        int index = ArrayUtils.indexOf(SORTED_SCOPES, scope);
        return index <= (thanIndex = ArrayUtils.indexOf(SORTED_SCOPES, than));
    }
}

