/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.HttpsTrust;

public class DefaultHttpDownloader
extends HttpDownloader {
    private final BaseHttpDownloader downloader;
    private final Integer readTimeout;
    private final Integer connectTimeout;

    public DefaultHttpDownloader(Server server, Settings settings) {
        this(server, settings, null);
    }

    public DefaultHttpDownloader(Server server, Settings settings, @Nullable Integer readTimeout) {
        this(server, settings, null, readTimeout);
    }

    public DefaultHttpDownloader(Server server, Settings settings, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.downloader = new BaseHttpDownloader(settings.getProperties(), server.getVersion());
    }

    public DefaultHttpDownloader(Settings settings) {
        this(settings, null);
    }

    public DefaultHttpDownloader(Settings settings, @Nullable Integer readTimeout) {
        this(settings, null, readTimeout);
    }

    public DefaultHttpDownloader(Settings settings, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.downloader = new BaseHttpDownloader(settings.getProperties(), null);
    }

    @Override
    protected String description(URI uri) {
        return String.format("%s (%s)", uri.toString(), this.getProxySynthesis(uri));
    }

    @Override
    protected String[] getSupportedSchemes() {
        return new String[]{"http", "https"};
    }

    @Override
    protected byte[] readBytes(URI uri) {
        return this.download(uri);
    }

    @Override
    protected String readString(URI uri, Charset charset) {
        try {
            return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout), (Charset)charset));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    @Override
    public String downloadPlainText(URI uri, String encoding) {
        return this.readString(uri, Charset.forName(encoding));
    }

    @Override
    public byte[] download(URI uri) {
        try {
            return ByteStreams.toByteArray(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public String getProxySynthesis(URI uri) {
        return BaseHttpDownloader.getProxySynthesis(uri);
    }

    @Override
    public InputStream openStream(URI uri) {
        try {
            return (InputStream)this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout).getInput();
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    @Override
    public void download(URI uri, File toFile) {
        try {
            Files.copy(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout), (File)toFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly(toFile);
            throw this.failToDownload(uri, e);
        }
    }

    private SonarException failToDownload(URI uri, IOException e) {
        throw new SonarException(String.format("Fail to download: %s (%s)", uri, this.getProxySynthesis(uri)), e);
    }

    public static class BaseHttpDownloader {
        private static final String GET = "GET";
        private static final String HTTP_PROXY_USER = "http.proxyUser";
        private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
        private static final List<String> PROXY_SETTINGS = ImmutableList.of((Object)"http.proxyHost", (Object)"http.proxyPort", (Object)"http.nonProxyHosts", (Object)"http.auth.ntlm.domain", (Object)"socksProxyHost", (Object)"socksProxyPort");
        private String userAgent;

        public BaseHttpDownloader(Map<String, String> settings, @Nullable String userAgent) {
            this.initProxy(settings);
            this.initUserAgent(userAgent);
        }

        private void initProxy(Map<String, String> settings) {
            this.propagateProxySystemProperties(settings);
            if (this.requiresProxyAuthentication(settings)) {
                this.registerProxyCredentials(settings);
            }
        }

        private void initUserAgent(@Nullable String sonarVersion) {
            this.userAgent = sonarVersion == null ? "SonarQube" : String.format("SonarQube %s", sonarVersion);
            System.setProperty("http.agent", this.userAgent);
        }

        private static String getProxySynthesis(URI uri) {
            return BaseHttpDownloader.getProxySynthesis(uri, ProxySelector.getDefault());
        }

        @VisibleForTesting
        static String getProxySynthesis(URI uri, ProxySelector proxySelector) {
            List<Proxy> proxies = proxySelector.select(uri);
            if (proxies.size() == 1 && proxies.get(0).type().equals((Object)Proxy.Type.DIRECT)) {
                return "no proxy";
            }
            ArrayList descriptions = Lists.newArrayList();
            for (Proxy proxy : proxies) {
                if (proxy.type() == Proxy.Type.DIRECT) continue;
                descriptions.add((Object)((Object)proxy.type()) + " proxy: " + proxy.address());
            }
            return Joiner.on((String)", ").join((Iterable)descriptions);
        }

        private void registerProxyCredentials(Map<String, String> settings) {
            Authenticator.setDefault(new ProxyAuthenticator(settings.get(HTTP_PROXY_USER), settings.get(HTTP_PROXY_PASSWORD)));
        }

        private boolean requiresProxyAuthentication(Map<String, String> settings) {
            return settings.containsKey(HTTP_PROXY_USER);
        }

        private void propagateProxySystemProperties(Map<String, String> settings) {
            for (String key : PROXY_SETTINGS) {
                if (!settings.containsKey(key)) continue;
                System.setProperty(key, settings.get(key));
            }
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri) {
            return this.newInputSupplier(uri, GET, null, null, null, null);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, GET, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, GET, connectTimeoutMillis, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String requestMethod, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, requestMethod, null, null, connectTimeoutMillis, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String requestMethod, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, requestMethod, null, null, null, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String login, String password) {
            return this.newInputSupplier(uri, GET, login, password);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String requestMethod, String login, String password) {
            return this.newInputSupplier(uri, requestMethod, login, password, null, null);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String login, String password, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, GET, login, password, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String requestMethod, String login, String password, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, requestMethod, login, password, null, readTimeoutMillis);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String requestMethod, String login, String password, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            int read = readTimeoutMillis != null ? readTimeoutMillis : 20000;
            int connect = connectTimeoutMillis != null ? connectTimeoutMillis : 20000;
            return new HttpInputSupplier(uri, requestMethod, this.userAgent, login, password, connect, read);
        }

        private static class ProxyAuthenticator
        extends Authenticator {
            private final PasswordAuthentication auth;

            ProxyAuthenticator(String user, String password) {
                this.auth = new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return this.auth;
            }
        }

        private static class HttpInputSupplier
        implements InputSupplier<InputStream> {
            private final String login;
            private final String password;
            private final URI uri;
            private final String userAgent;
            private final int connectTimeoutMillis;
            private final int readTimeoutMillis;
            private final String requestMethod;

            HttpInputSupplier(URI uri, String requestMethod, String userAgent, String login, String password, int connectTimeoutMillis, int readTimeoutMillis) {
                this.uri = uri;
                this.requestMethod = requestMethod;
                this.userAgent = userAgent;
                this.login = login;
                this.password = password;
                this.readTimeoutMillis = readTimeoutMillis;
                this.connectTimeoutMillis = connectTimeoutMillis;
            }

            public InputStream getInput() throws IOException {
                Loggers.get(this.getClass()).debug("Download: " + this.uri + " (" + BaseHttpDownloader.getProxySynthesis(this.uri, ProxySelector.getDefault()) + ")");
                HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection();
                connection.setRequestMethod(this.requestMethod);
                HttpsTrust.INSTANCE.trust(connection);
                connection.setRequestProperty("Accept-Encoding", "gzip");
                if (!Strings.isNullOrEmpty((String)this.login)) {
                    String encoded = Base64.encodeBase64String((this.login + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encoded);
                }
                connection.setConnectTimeout(this.connectTimeoutMillis);
                connection.setReadTimeout(this.readTimeoutMillis);
                connection.setUseCaches(true);
                connection.setInstanceFollowRedirects(true);
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                String encoding = connection.getContentEncoding();
                int responseCode = connection.getResponseCode();
                if (responseCode >= 400) {
                    InputStream errorResponse = null;
                    try {
                        errorResponse = connection.getErrorStream();
                        if (errorResponse != null) {
                            String errorResponseContent = IOUtils.toString(errorResponse);
                            throw new HttpDownloader.HttpException(this.uri, responseCode, errorResponseContent);
                        }
                        throw new HttpDownloader.HttpException(this.uri, responseCode);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(errorResponse);
                        throw throwable;
                    }
                }
                InputStream resultingInputStream = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
                return resultingInputStream;
            }
        }
    }
}

