/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.Version;

public class PluginInfo
implements Comparable<PluginInfo> {
    private static final Joiner SLASH_JOINER = Joiner.on((String)" / ").skipNulls();
    private final String key;
    private String name;
    @CheckForNull
    private File jarFile;
    @CheckForNull
    private String mainClass;
    @CheckForNull
    private Version version;
    @CheckForNull
    private Version minimalSqVersion;
    @CheckForNull
    private String description;
    @CheckForNull
    private String organizationName;
    @CheckForNull
    private String organizationUrl;
    @CheckForNull
    private String license;
    @CheckForNull
    private String homepageUrl;
    @CheckForNull
    private String issueTrackerUrl;
    private boolean useChildFirstClassLoader;
    @CheckForNull
    private String basePlugin;
    @CheckForNull
    private String implementationBuild;
    private final Set<RequiredPlugin> requiredPlugins = new HashSet<RequiredPlugin>();

    public PluginInfo(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Plugin key is missing from manifest");
        this.key = key;
        this.name = key;
    }

    public PluginInfo setJarFile(@Nullable File f) {
        this.jarFile = f;
        return this;
    }

    @CheckForNull
    public File getJarFile() {
        return this.jarFile;
    }

    public File getNonNullJarFile() {
        Preconditions.checkNotNull((Object)this.jarFile);
        return this.jarFile;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public Version getVersion() {
        return this.version;
    }

    @CheckForNull
    public Version getMinimalSqVersion() {
        return this.minimalSqVersion;
    }

    @CheckForNull
    public String getMainClass() {
        return this.mainClass;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @CheckForNull
    public String getOrganizationName() {
        return this.organizationName;
    }

    @CheckForNull
    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @CheckForNull
    public String getLicense() {
        return this.license;
    }

    @CheckForNull
    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    @CheckForNull
    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    @CheckForNull
    public String getBasePlugin() {
        return this.basePlugin;
    }

    @CheckForNull
    public String getImplementationBuild() {
        return this.implementationBuild;
    }

    public Set<RequiredPlugin> getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public PluginInfo setName(@Nullable String name) {
        this.name = (String)Objects.firstNonNull((Object)name, (Object)this.key);
        return this;
    }

    public PluginInfo setVersion(Version version) {
        this.version = version;
        return this;
    }

    public PluginInfo setMinimalSqVersion(@Nullable Version v) {
        this.minimalSqVersion = v;
        return this;
    }

    public PluginInfo setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public PluginInfo setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public PluginInfo setOrganizationName(@Nullable String s) {
        this.organizationName = s;
        return this;
    }

    public PluginInfo setOrganizationUrl(@Nullable String s) {
        this.organizationUrl = s;
        return this;
    }

    public PluginInfo setLicense(@Nullable String license) {
        this.license = license;
        return this;
    }

    public PluginInfo setHomepageUrl(@Nullable String s) {
        this.homepageUrl = s;
        return this;
    }

    public PluginInfo setIssueTrackerUrl(@Nullable String s) {
        this.issueTrackerUrl = s;
        return this;
    }

    public PluginInfo setUseChildFirstClassLoader(boolean b) {
        this.useChildFirstClassLoader = b;
        return this;
    }

    public PluginInfo setBasePlugin(@Nullable String s) {
        if ("l10nen".equals(s)) {
            Loggers.get(PluginInfo.class).info("Plugin [{}] defines 'l10nen' as base plugin. This metadata can be removed from manifest of l10n plugins since version 5.2.", (Object)this.key);
            this.basePlugin = null;
        } else {
            this.basePlugin = s;
        }
        return this;
    }

    public PluginInfo setImplementationBuild(@Nullable String implementationBuild) {
        this.implementationBuild = implementationBuild;
        return this;
    }

    public PluginInfo addRequiredPlugin(RequiredPlugin p) {
        this.requiredPlugins.add(p);
        return this;
    }

    public boolean isCompatibleWith(String sqVersion) {
        if (null == this.minimalSqVersion) {
            return true;
        }
        Version effectiveMin = Version.create(this.minimalSqVersion.getName()).removeQualifier();
        Version actualVersion = Version.create(sqVersion).removeQualifier();
        return actualVersion.compareTo(effectiveMin) >= 0;
    }

    public String toString() {
        return String.format("[%s]", SLASH_JOINER.join((Object)this.key, (Object)this.version, new Object[]{this.implementationBuild}));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo info = (PluginInfo)o;
        if (!this.key.equals(info.key)) {
            return false;
        }
        return !(this.version == null ? info.version != null : !this.version.equals(info.version));
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(PluginInfo that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Object)this.version, (Object)that.version, (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public static PluginInfo create(File jarFile) {
        try {
            PluginManifest manifest = new PluginManifest(jarFile);
            return PluginInfo.create(jarFile, manifest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to extract plugin metadata from file: " + jarFile, e);
        }
    }

    @VisibleForTesting
    static PluginInfo create(File jarFile, PluginManifest manifest) {
        if (StringUtils.isBlank(manifest.getKey())) {
            throw MessageException.of(String.format("File is not a plugin. Please delete it and restart: %s", jarFile.getAbsolutePath()));
        }
        PluginInfo info = new PluginInfo(manifest.getKey());
        info.setJarFile(jarFile);
        info.setName(manifest.getName());
        info.setMainClass(manifest.getMainClass());
        info.setVersion(Version.create(manifest.getVersion()));
        info.setDescription(manifest.getDescription());
        info.setLicense(manifest.getLicense());
        info.setOrganizationName(manifest.getOrganization());
        info.setOrganizationUrl(manifest.getOrganizationUrl());
        String minSqVersion = manifest.getSonarVersion();
        if (minSqVersion != null) {
            info.setMinimalSqVersion(Version.create(minSqVersion));
        }
        info.setHomepageUrl(manifest.getHomepage());
        info.setIssueTrackerUrl(manifest.getIssueTrackerUrl());
        info.setUseChildFirstClassLoader(manifest.isUseChildFirstClassLoader());
        info.setBasePlugin(manifest.getBasePlugin());
        info.setImplementationBuild(manifest.getImplementationBuild());
        String[] requiredPlugins = manifest.getRequirePlugins();
        if (requiredPlugins != null) {
            for (String s : requiredPlugins) {
                info.addRequiredPlugin(RequiredPlugin.parse(s));
            }
        }
        return info;
    }

    public static Function<File, PluginInfo> jarToPluginInfo() {
        return JarToPluginInfo.INSTANCE;
    }

    private static enum JarToPluginInfo implements Function<File, PluginInfo>
    {
        INSTANCE;


        public PluginInfo apply(@Nonnull File jarFile) {
            return PluginInfo.create(jarFile);
        }
    }

    public static class RequiredPlugin {
        private static final Pattern PARSER = Pattern.compile("\\w+:.+");
        private final String key;
        private final Version minimalVersion;

        public RequiredPlugin(String key, Version minimalVersion) {
            this.key = key;
            this.minimalVersion = minimalVersion;
        }

        public String getKey() {
            return this.key;
        }

        public Version getMinimalVersion() {
            return this.minimalVersion;
        }

        public static RequiredPlugin parse(String s) {
            if (!PARSER.matcher(s).matches()) {
                throw new IllegalArgumentException("Manifest field does not have correct format: " + s);
            }
            String[] fields = StringUtils.split(s, ':');
            return new RequiredPlugin(fields[0], Version.create(fields[1]).removeQualifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequiredPlugin that = (RequiredPlugin)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + ':' + this.minimalVersion.getName();
        }
    }
}

